/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ui;

import java.awt.Component;
import java.awt.Graphics;
import org.bluray.ui.AnimationParameters;
import org.bluray.ui.FrameAccurateAnimationTimer;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public abstract class FrameAccurateAnimation
extends Component {
    private BDJXletContext context;
    protected boolean running;
    protected AnimationParameters params;
    public static final float FRAME_RATE_23_976 = 23.976f;
    public static final float FRAME_RATE_24 = 24.0f;
    public static final float FRAME_RATE_25 = 25.0f;
    public static final float FRAME_RATE_29_97 = 29.97f;
    public static final float FRAME_RATE_50 = 50.0f;
    public static final float FRAME_RATE_59_94 = 59.94f;
    private static final long serialVersionUID = 76982966057159330L;
    private static float defaultRate = 25.0f;
    private static final Logger logger = Logger.getLogger(FrameAccurateAnimation.class.getName());

    public static final float getDefaultFrameRate() {
        return defaultRate;
    }

    public static boolean setDefaultFrameRate(float framerate) {
        if (framerate != 23.976f && framerate != 24.0f && framerate != 25.0f && framerate != 29.97f && framerate != 50.0f && framerate != 59.94f) {
            return false;
        }
        defaultRate = framerate;
        return true;
    }

    public FrameAccurateAnimation() {
        logger.unimplemented("FrameAccurateAnimation");
    }

    public FrameAccurateAnimation(AnimationParameters params) {
        this.context = BDJXletContext.getCurrentContext();
        if (this.context != null) {
            this.context.addFAA(this);
        } else {
            logger.error("FrameAccurateAnimation created from wrong thread: " + logger.dumpStack());
        }
        this.params = new AnimationParameters(params);
    }

    public synchronized void destroy() {
        if (this.context != null) {
            this.context.removeFAA(this);
            this.context = null;
        }
        this.destroyImpl();
    }

    public long getCompletedFrameCount() {
        logger.unimplemented("getCompletedFrameCount");
        return 0L;
    }

    public float getFrameRate() {
        logger.unimplemented("getFrameRate");
        return FrameAccurateAnimation.getDefaultFrameRate();
    }

    public Graphics getGraphics() {
        logger.unimplemented("getGraphics");
        return super.getGraphics();
    }

    public int[] getRepeatCounts() {
        int[] repeatCount = null;
        if (this.params != null && this.params.repeatCount != null) {
            repeatCount = (int[])this.params.repeatCount.clone();
        }
        return repeatCount;
    }

    public int getThreadPriority() {
        return this.params.threadPriority;
    }

    public synchronized boolean isAnimated() {
        return this.running;
    }

    public void paint(Graphics g) {
        logger.unimplemented("paint");
    }

    public synchronized void resetStartStopTime(FrameAccurateAnimationTimer newTimer) {
        this.params.faaTimer = new FrameAccurateAnimationTimer(newTimer);
        logger.unimplemented("resetStartStopTime");
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void setThreadPriority(int p) {
        this.params.threadPriority = p;
    }

    protected void startImpl() {
        logger.unimplemented("startImpl");
    }

    protected void stopImpl() {
        logger.unimplemented("stopImpl");
    }

    protected void destroyImpl() {
        logger.unimplemented("destroyImpl");
    }

    public synchronized void start() {
        if (!this.running) {
            this.running = true;
            if (this.params.faaTimer != null) {
                logger.unimplemented("start(faaTimer)");
            }
            this.startImpl();
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.stopImpl();
        }
    }

    public String toString() {
        return "FrameAccurateAnimation";
    }
}

