/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame2.driver;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.sesame2.driver.VirtuosoRepositoryConnection;

public class VirtuosoRepository
implements Repository {
    ValueFactory valueFactory = new ValueFactoryImpl();
    File dataDir;
    private VirtuosoConnectionPoolDataSource pds = new VirtuosoConnectionPoolDataSource();
    private String url_hostlist;
    private String user;
    private String password;
    private int resultsHandlerType = 0;
    private boolean roundrobin;
    private String charset = "UTF-8";
    static final String utf8 = "charset=utf-8";
    private boolean initialized = false;
    private DataSource _ds;
    private ConnectionPoolDataSource _pds;
    boolean useLazyAdd = false;
    String defGraph;
    int prefetchSize = 200;
    int batchSize = 5000;
    int queryTimeout = 0;
    String ruleSet;

    public VirtuosoRepository(ConnectionPoolDataSource connectionPoolDataSource, String string, boolean bl) {
        this.defGraph = string;
        this.useLazyAdd = bl;
        this._pds = connectionPoolDataSource;
    }

    public VirtuosoRepository(DataSource dataSource, String string, boolean bl) {
        this.defGraph = string;
        this.useLazyAdd = bl;
        this._ds = dataSource;
    }

    public VirtuosoRepository(String string, String string2, String string3, String string4, boolean bl) {
        this.url_hostlist = string.trim();
        this.user = string2;
        this.password = string3;
        this.defGraph = string4;
        this.useLazyAdd = bl;
    }

    public VirtuosoRepository(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, "sesame:nil", bl);
    }

    public VirtuosoRepository(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, false);
    }

    public VirtuosoRepository(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this._pds != null) {
            try {
                PooledConnection pooledConnection = this._pds.getPooledConnection();
                Connection connection = pooledConnection.getConnection();
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception exception) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)exception);
            }
        }
        if (this._ds != null) {
            try {
                Connection connection = this._ds.getConnection();
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception exception) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)exception);
            }
        }
        if (this.url_hostlist.startsWith("jdbc:virtuoso://")) {
            try {
                Class.forName("virtuoso.jdbc4.Driver");
                String string = this.url_hostlist;
                if (string.toLowerCase().indexOf(utf8) == -1) {
                    string = string.charAt(string.length() - 1) != '/' ? string + "/charset=UTF-8" : string + "charset=UTF-8";
                }
                if (this.roundrobin && string.toLowerCase().indexOf("roundrobin=") == -1) {
                    string = string.charAt(string.length() - 1) != '/' ? string + "/roundrobin=1" : string + "roundrobin=1";
                }
                Connection connection = DriverManager.getConnection(string, this.user, this.password);
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception exception) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)exception);
            }
        }
        try {
            this.pds.setServerName(this.url_hostlist);
            this.pds.setUser(this.user);
            this.pds.setPassword(this.password);
            this.pds.setCharset(this.charset);
            this.pds.setRoundrobin(this.roundrobin);
            PooledConnection pooledConnection = this.pds.getPooledConnection();
            Connection connection = pooledConnection.getConnection();
            return new VirtuosoRepositoryConnection(this, connection);
        }
        catch (Exception exception) {
            System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
            throw new RepositoryException((Throwable)exception);
        }
    }

    public void setFetchSize(int n) {
        this.prefetchSize = n;
    }

    public int getFetchSize() {
        return this.prefetchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setRoundrobin(boolean bl) {
        this.roundrobin = bl;
    }

    public boolean getRoundrobin() {
        return this.roundrobin;
    }

    public void setRuleSet(String string) {
        if (string != null && string.equals("null")) {
            string = null;
        }
        this.ruleSet = string;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void initialize() throws RepositoryException {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isWritable() throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("VirtuosoRepository not initialized.");
        }
        return true;
    }

    public void setDataDir(File file) {
        this.dataDir = file;
    }

    public void shutDown() throws RepositoryException {
        this.initialized = false;
    }

    public int getResultsHandlerType() {
        return this.resultsHandlerType;
    }

    public void setResultsHandlerType(int n) {
        this.resultsHandlerType = n;
    }

    public void createRuleSet(String string, String string2) throws RepositoryException {
        Connection connection = ((VirtuosoRepositoryConnection)this.getConnection()).getQuadStoreConnection();
        try {
            Statement statement = connection.createStatement();
            statement.execute("rdfs_rule_set('" + string + "', '" + string2 + "')");
            statement.close();
        }
        catch (Exception exception) {
            throw new RepositoryException((Throwable)exception);
        }
    }
}

