/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockNone;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtDataSource
extends VirtGraph
implements DataSource,
Dataset {
    Model defaultModel = null;
    Lock lock = null;

    public VirtDataSource() {
    }

    protected VirtDataSource(VirtGraph virtGraph) {
        this.graphName = virtGraph.getGraphName();
        this.setReadFromAllGraphs(virtGraph.getReadFromAllGraphs());
        this.url_hostlist = virtGraph.getGraphUrl();
        this.user = virtGraph.getGraphUser();
        this.password = virtGraph.getGraphPassword();
        this.roundrobin = virtGraph.roundrobin;
        this.setFetchSize(virtGraph.getFetchSize());
        this.connection = virtGraph.getConnection();
    }

    public VirtDataSource(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void setDefaultModel(Model model) {
        this.defaultModel = model;
    }

    public void addNamedModel(String string, Model model) throws LabelExistsException {
        PreparedStatement preparedStatement;
        String string2 = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet resultSet = null;
        int n = 0;
        this.checkOpen();
        try {
            preparedStatement = this.getConnection().prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
            resultSet.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        try {
            if (n != 0) {
                throw new LabelExistsException("A model with ID '" + string + "' already exists.");
            }
            preparedStatement = model.getGraph();
            int n2 = 0;
            PreparedStatement preparedStatement2 = this.getConnection().prepareStatement("sparql define output:format '_JAVA_' insert into graph iri(??) { `iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)` }");
            ExtendedIterator extendedIterator = preparedStatement.find(Node.ANY, Node.ANY, Node.ANY);
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                preparedStatement2.setString(1, string);
                this.bindSubject(preparedStatement2, 2, triple.getSubject());
                this.bindPredicate(preparedStatement2, 3, triple.getPredicate());
                this.bindObject(preparedStatement2, 4, triple.getObject());
                preparedStatement2.addBatch();
                if (++n2 <= 5000) continue;
                preparedStatement2.executeBatch();
                preparedStatement2.clearBatch();
                n2 = 0;
            }
            if (n2 > 0) {
                preparedStatement2.executeBatch();
                preparedStatement2.clearBatch();
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void removeNamedModel(String string) {
        String string2 = "sparql clear graph <" + string + ">";
        this.checkOpen();
        try {
            Statement statement = this.getConnection().createStatement();
            statement.executeQuery(string2);
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void replaceNamedModel(String string, Model model) {
        try {
            this.getConnection().setAutoCommit(false);
            this.removeNamedModel(string);
            this.addNamedModel(string, model);
            this.getConnection().commit();
            this.getConnection().setAutoCommit(true);
        }
        catch (Exception exception) {
            try {
                this.getConnection().rollback();
            }
            catch (Exception exception2) {
                throw new JenaException("Could not replace model, and could not rollback!", (Throwable)exception2);
            }
            throw new JenaException("Could not replace model:", (Throwable)exception);
        }
    }

    public Model getDefaultModel() {
        return this.defaultModel;
    }

    public Model getNamedModel(String string) {
        try {
            return new VirtModel(new VirtGraph(string, this.getGraphUrl(), this.getGraphUser(), this.getGraphPassword()));
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public boolean containsNamedModel(String string) {
        String string2 = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet resultSet = null;
        int n = 0;
        this.checkOpen();
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
            resultSet.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        return n != 0;
    }

    public Iterator<String> listNames() {
        String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        ResultSet resultSet = null;
        boolean bl = false;
        this.checkOpen();
        try {
            Vector<String> vector = new Vector<String>();
            Statement statement = this.getConnection().createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
            return vector.iterator();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockNone();
        }
        return this.lock;
    }

    public DatasetGraph asDatasetGraph() {
        return null;
    }
}

