/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateStringLiteral;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateStringLiteralInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final int MAX_FILES_TO_ON_THE_FLY_SEARCH = 10;
    public int MIN_STRING_LENGTH = 5;
    public boolean IGNORE_PROPERTY_KEYS;
    @NonNls
    private static final String BR = "<br>";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitExpression((PsiExpression)expression);
            }

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                DuplicateStringLiteralInspection.this.checkStringLiteralExpression(expression, holder, isOnTheFly);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public String getShortName() {
        return "DuplicateStringLiteralInspection";
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiterals(final @NotNull StringLiteralSearchQuery query, final @NotNull Project project) {
        if (query == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(2);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List words = ContainerUtil.filter((Collection)StringUtil.getWordsInStringLongestFirst((String)query.stringToFind), s -> s.length() >= query.minStringLength);
        if (words.isEmpty()) {
            List<PsiLiteralExpression> list = Collections.emptyList();
            if (list == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList foundExpressions = new SmartList();
        CacheManager.getInstance((Project)project).processVirtualFilesWithAllWords((Collection)words, (short)4, scope, true, (Processor)new Processor<VirtualFile>((List)foundExpressions){
            int filesWithLiterals;
            final /* synthetic */ List val$foundExpressions;
            {
                this.val$foundExpressions = list;
            }

            public boolean process(VirtualFile f) {
                List<PsiLiteralExpression> duplicateLiteralsInFile;
                FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(f);
                if (viewProvider == null || viewProvider.getPsi((Language)JavaLanguage.INSTANCE) == null) {
                    return true;
                }
                PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
                if (psiFile != null && !(duplicateLiteralsInFile = DuplicateStringLiteralInspection.findDuplicateLiteralsInFile(query.stringToFind, query.ignorePropertyKeys, psiFile)).isEmpty()) {
                    this.val$foundExpressions.addAll(duplicateLiteralsInFile);
                    if (query.isOnFlySearch && ++this.filesWithLiterals >= 10) {
                        return false;
                    }
                }
                return true;
            }
        });
        SmartList smartList = foundExpressions;
        if (smartList == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiteralsInFile(@NotNull String stringToFind, boolean ignorePropertyKeys, @NotNull PsiFile file) {
        if (stringToFind == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        CharSequence text = file.getViewProvider().getContents();
        StringSearcher searcher = new StringSearcher(stringToFind, true, true);
        SmartList foundExpr = new SmartList();
        LowLevelSearchUtil.processTexts((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, arg_0 -> DuplicateStringLiteralInspection.lambda$findDuplicateLiteralsInFile$1(file, stringToFind, ignorePropertyKeys, (List)foundExpr, arg_0));
        SmartList smartList = foundExpr;
        if (smartList == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private void checkStringLiteralExpression(@NotNull PsiLiteralExpression originalExpression, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiExpression[] foundExpr;
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(9);
        }
        if ((foundExpr = this.getDuplicateLiterals(holder.getProject(), originalExpression, isOnTheFly)).length == 0) {
            return;
        }
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (PsiExpression aClass2 : foundExpr) {
            if (aClass2 == originalExpression) continue;
            ProgressManager.checkCanceled();
            while ((aClass2 = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class)) != null && ((PsiClass)aClass2).getQualifiedName() == null) {
            }
            if (aClass2 == null) continue;
            classes.add((PsiClass)aClass2);
        }
        if (classes.isEmpty()) {
            return;
        }
        List tenClassesMost = ContainerUtil.getFirstItems(Arrays.asList(classes.toArray(PsiClass.EMPTY_ARRAY)), (int)10);
        Object classList = isOnTheFly ? StringUtil.join((Collection)tenClassesMost, aClass -> {
            boolean thisFile = aClass.getContainingFile() == originalExpression.getContainingFile();
            return "&nbsp;&nbsp;&nbsp;'<b>" + aClass.getQualifiedName() + "</b>'" + (String)(thisFile ? " " + JavaI18nBundle.message("inspection.duplicates.message.in.this.file", new Object[0]) : "");
        }, (String)", <br>") : StringUtil.join((Collection)tenClassesMost, aClass -> "'" + aClass.getQualifiedName() + "'", (String)", ");
        if (classes.size() > tenClassesMost.size()) {
            classList = (String)classList + BR + JavaI18nBundle.message("inspection.duplicates.message.more", classes.size() - 10);
        }
        String msg = JavaI18nBundle.message("inspection.duplicates.message", classList);
        SmartList fixes = new SmartList();
        if (isOnTheFly) {
            fixes.add(new IntroduceLiteralConstantFix());
            fixes.add(new NavigateToOccurrencesFix(originalExpression));
        }
        DuplicateStringLiteralInspection.createReplaceFixes(foundExpr, originalExpression, (Collection<? super LocalQuickFix>)fixes);
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem((PsiElement)originalExpression, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, array);
    }

    private PsiExpression @NotNull [] getDuplicateLiterals(@NotNull Project project, @NotNull PsiLiteralExpression place, boolean isOnTheFly) {
        Object value;
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(10);
        }
        if (place == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(11);
        }
        if (!((value = place.getValue()) instanceof String)) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(12);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        String stringToFind = (String)value;
        if (!DuplicateStringLiteralInspection.shouldCheck(place, this.IGNORE_PROPERTY_KEYS)) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(13);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        if (stringToFind.isEmpty()) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(14);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap duplicates = ConcurrentFactoryMap.createMap(q -> DuplicateStringLiteralInspection.findDuplicateLiterals(q, project).toArray(PsiExpression.EMPTY_ARRAY));
            return CachedValueProvider.Result.create((Object)duplicates, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        PsiExpression[] psiExpressionArray = (PsiExpression[])map.get(new StringLiteralSearchQuery(stringToFind, this.IGNORE_PROPERTY_KEYS, this.MIN_STRING_LENGTH, isOnTheFly));
        if (psiExpressionArray == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(15);
        }
        return psiExpressionArray;
    }

    private static boolean shouldCheck(@NotNull PsiLiteralExpression expression, boolean ignorePropertyKeys) {
        if (expression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(16);
        }
        if (ignorePropertyKeys && JavaI18nUtil.mustBePropertyKey((PsiExpression)expression, null)) {
            return false;
        }
        return !SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)expression);
    }

    private static void createReplaceFixes(PsiExpression @NotNull [] foundExpr, @NotNull PsiLiteralExpression originalExpression, @NotNull Collection<? super LocalQuickFix> fixes) {
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(17);
        }
        if (fixes == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(18);
        }
        if (foundExpr == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(19);
        }
        for (PsiExpression expr : foundExpr) {
            boolean isAccessible;
            PsiClass containingClass;
            PsiField field;
            PsiElement parent;
            if (expr == originalExpression || !((parent = expr.getParent()) instanceof PsiField) || (field = (PsiField)parent).getInitializer() != expr || !field.hasModifierProperty("static") || (containingClass = field.getContainingClass()) == null || !(isAccessible = JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper().isAccessible((PsiMember)field, (PsiElement)originalExpression, containingClass)) && containingClass.getQualifiedName() == null) continue;
            fixes.add((LocalQuickFix)LocalQuickFix.from((ModCommandAction)new ReplaceFix(field, originalExpression)));
        }
    }

    @Nullable
    private static PsiReferenceExpression createReferenceTo(@NotNull PsiField constant) throws IncorrectOperationException {
        if (constant == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(20);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constant.getProject()).getElementFactory();
        PsiReferenceExpression reference = (PsiReferenceExpression)factory.createExpressionFromText("XXX." + constant.getName(), null);
        PsiReferenceExpression classQualifier = (PsiReferenceExpression)reference.getQualifierExpression();
        PsiClass containingClass = constant.getContainingClass();
        if (containingClass.getQualifiedName() == null) {
            return null;
        }
        classQualifier.bindToElement((PsiElement)containingClass);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        return null;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"MIN_STRING_LENGTH", (String)JavaI18nBundle.message("inspection.duplicates.option", new Object[0]), (int)1, (int)10000), OptPane.checkbox((String)"IGNORE_PROPERTY_KEYS", (String)JavaI18nBundle.message("inspection.duplicates.option.report.propertykey.expressions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(21);
        }
        return optPane;
    }

    private PsiExpression @Nullable [] getDuplicateLiteralsUnderProgress(@NotNull PsiElement literalExpression) {
        if (literalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(22);
        }
        if (!(literalExpression instanceof PsiLiteralExpression)) {
            return null;
        }
        Project project = literalExpression.getProject();
        ThrowableComputable findDuplicatesComputable = () -> (PsiExpression[])ReadAction.compute(() -> this.getDuplicateLiterals(project, (PsiLiteralExpression)literalExpression, false));
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)literalExpression)) {
            Object[] expressions = (PsiExpression[])findDuplicatesComputable.compute();
            if (expressions == null) {
                return null;
            }
            PsiFile file = literalExpression.getContainingFile();
            return (PsiExpression[])ContainerUtil.map2Array((Object[])expressions, (Object[])PsiExpression.EMPTY_ARRAY, e -> (PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)e, (PsiFile)file));
        }
        return (PsiExpression[])ProgressManager.getInstance().runProcessWithProgressSynchronously(findDuplicatesComputable, JavaI18nBundle.message("progress.title.searching.for.duplicates.of.0", ((PsiLiteralExpression)literalExpression).getValue()), true, project);
    }

    private static void introduceConstant(final PsiExpression @NotNull [] expressions, @NotNull Project project) {
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(23);
        }
        if (expressions == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(24);
        }
        new IntroduceConstantHandler(){

            protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
                return new BaseOccurrenceManager(occurrence -> true){

                    protected PsiExpression @NotNull [] defaultOccurrences() {
                        if (expressions == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return expressions;
                    }

                    protected PsiExpression @NotNull [] findOccurrences() {
                        if (expressions == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return expressions;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "defaultOccurrences";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "findOccurrences";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }
        }.invoke(project, expressions);
    }

    private static /* synthetic */ boolean lambda$findDuplicateLiteralsInFile$1(PsiFile file, String stringToFind, boolean ignorePropertyKeys, List foundExpr, int offset) {
        PsiElement patt5896$temp;
        PsiElement element = file.findElementAt(offset);
        if (element == null || !((patt5896$temp = element.getParent()) instanceof PsiLiteralExpression)) {
            return true;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)patt5896$temp;
        if (Comparing.equal((Object)stringToFind, (Object)expression.getValue()) && DuplicateStringLiteralInspection.shouldCheck(expression, ignorePropertyKeys)) {
            foundExpr.add(expression);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 12, 13, 14, 15, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundExpr";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicateLiterals";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicateLiteralsInFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateLiterals";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateLiterals";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateLiteralsInFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkStringLiteralExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateLiterals";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceFixes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateLiteralsUnderProgress";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "introduceConstant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 12, 13, 14, 15, 21 -> new IllegalStateException(string);
        };
    }

    private record StringLiteralSearchQuery(@NotNull String stringToFind, boolean ignorePropertyKeys, int minStringLength, boolean isOnFlySearch) {
        @NotNull
        private final String stringToFind;

        private StringLiteralSearchQuery(@NotNull String stringToFind, boolean ignorePropertyKeys, int minStringLength, boolean isOnFlySearch) {
            if (stringToFind == null) {
                StringLiteralSearchQuery.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String stringToFind() {
            String string = this.stringToFind;
            if (string == null) {
                StringLiteralSearchQuery.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringToFind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$StringLiteralSearchQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$StringLiteralSearchQuery";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stringToFind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class IntroduceLiteralConstantFix
    extends IntroduceConstantFix {
        private IntroduceLiteralConstantFix() {
            super(JavaI18nBundle.message("introduce.constant.across.the.project", new Object[0]));
        }

        protected void doIntroduce(@NotNull Project project, PsiExpression element) {
            PsiExpression[] literalExpressions;
            if (project == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(0);
            }
            if ((literalExpressions = DuplicateStringLiteralInspection.this.getDuplicateLiteralsUnderProgress((PsiElement)element)) == null) {
                return;
            }
            DuplicateStringLiteralInspection.introduceConstant(literalExpressions, project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix", "doIntroduce"));
        }
    }

    private class NavigateToOccurrencesFix
    extends LocalQuickFixOnPsiElement {
        NavigateToOccurrencesFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, final @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiExpression[] literalExpressions;
            if (project == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(3);
            }
            if ((literalExpressions = DuplicateStringLiteralInspection.this.getDuplicateLiteralsUnderProgress(startElement)) == null) {
                return;
            }
            Usage[] usages = (Usage[])Stream.of(literalExpressions).map(UsageInfo::new).map(UsageInfo2UsageAdapter::new).toArray(Usage[]::new);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = JavaI18nBundle.message("inspection.duplicates.occurrences.view.title", ((PsiLiteralExpression)startElement).getValue());
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            presentation.setShowCancelButton(true);
            UsageView view = UsageViewManager.getInstance((Project)project).showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter(startElement, false){

                public String getPresentableText() {
                    return "String literal: '" + String.valueOf(((PsiLiteralExpression)startElement).getValue()) + "'";
                }
            }}, usages, presentation);
            view.addButtonToLowerPane(() -> {
                DuplicateStringLiteralInspection.introduceConstant(literalExpressions, project);
                view.close();
            }, JavaI18nBundle.message("introduce.constant.across.the.project", new Object[0]));
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("inspection.duplicates.navigate.to.occurrences", new Object[0]);
            if (string == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            PsiElement element;
            if (project == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(6);
            }
            if (previewDescriptor == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(7);
            }
            if ((element = previewDescriptor.getPsiElement()) instanceof PsiLiteralExpression) {
                PsiLiteralExpression literal = (PsiLiteralExpression)element;
                PsiExpression[] duplicates = DuplicateStringLiteralInspection.this.getDuplicateLiterals(project, literal, true);
                if (duplicates.length < 10) {
                    return new IntentionPreviewInfo.Html(JavaI18nBundle.message("inspection.duplicates.navigate.to.occurrences.preview", duplicates.length, literal.getText()));
                }
                return new IntentionPreviewInfo.Html(JavaI18nBundle.message("inspection.duplicates.navigate.to.many.occurrences.preview", duplicates.length, literal.getText()));
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$NavigateToOccurrencesFix";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$NavigateToOccurrencesFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ReplaceFix
    extends PsiUpdateModCommandAction<PsiLiteralExpression> {
        @IntentionName
        private final String myText;
        private final SmartPsiElementPointer<PsiField> myConst;

        private ReplaceFix(PsiField constant, PsiLiteralExpression originalExpression) {
            super((PsiElement)originalExpression);
            this.myText = JavaI18nBundle.message("inspection.duplicates.replace.quickfix", PsiFormatUtil.formatVariable((PsiVariable)constant, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            this.myConst = SmartPointerManager.getInstance((Project)constant.getProject()).createSmartPsiElementPointer((PsiElement)constant);
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiLiteralExpression element) {
            if (context == null) {
                ReplaceFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ReplaceFix.$$$reportNull$$$0(1);
            }
            Presentation presentation = Presentation.of((String)this.myText);
            if (presentation == null) {
                ReplaceFix.$$$reportNull$$$0(2);
            }
            return presentation;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiLiteralExpression literal, @NotNull ModPsiUpdater updater) {
            PsiReferenceExpression newReference;
            PsiField myConstant;
            if (context == null) {
                ReplaceFix.$$$reportNull$$$0(3);
            }
            if (literal == null) {
                ReplaceFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ReplaceFix.$$$reportNull$$$0(5);
            }
            if ((myConstant = (PsiField)this.myConst.getElement()) == null) {
                return;
            }
            PsiExpression initializer = myConstant.getInitializer();
            if (!(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            PsiReferenceExpression reference = DuplicateStringLiteralInspection.createReferenceTo(myConstant);
            if (reference != null && UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)(newReference = (PsiReferenceExpression)literal.replace((PsiElement)reference)), (boolean)false, (boolean)false, (boolean)true)) {
                newReference.getChildren()[0].delete();
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("inspection.duplicates.replace.family.quickfix", new Object[0]);
            if (string == null) {
                ReplaceFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6 -> new IllegalStateException(string);
            };
        }
    }
}

