/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.model.MavenId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\f\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesHelper;", "", "<init>", "()V", "getId", "Lorg/jetbrains/idea/maven/model/MavenId;", "context", "Lcom/intellij/util/xml/ConvertContext;", "getCoordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "getMavenId", "coords", "withVersion", "version", "", "intellij.maven"})
public final class MavenArtifactCoordinatesHelper {
    @NotNull
    public static final MavenArtifactCoordinatesHelper INSTANCE = new MavenArtifactCoordinatesHelper();

    private MavenArtifactCoordinatesHelper() {
    }

    @JvmStatic
    @NotNull
    public static final MavenId getId(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return MavenArtifactCoordinatesHelper.getMavenId(MavenArtifactCoordinatesHelper.getCoordinates(context2), context2);
    }

    @JvmStatic
    @NotNull
    public static final MavenDomShortArtifactCoordinates getCoordinates(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DomElement domElement = context2.getInvocationElement().getParent();
        Intrinsics.checkNotNull((Object)domElement, (String)"null cannot be cast to non-null type org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates");
        return (MavenDomShortArtifactCoordinates)domElement;
    }

    @JvmStatic
    @NotNull
    public static final MavenId getMavenId(@Nullable MavenDomShortArtifactCoordinates coords, @NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (coords instanceof MavenDomArtifactCoordinates) {
            String string = MavenDependencyCompletionUtil.removeDummy(((MavenDomArtifactCoordinates)coords).getVersion().getStringValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeDummy(...)");
            String version = string;
            if (!(((CharSequence)version).length() == 0)) {
                return MavenArtifactCoordinatesHelper.withVersion(coords, version);
            }
        }
        DomFileElement domFileElement = DomManager.getDomManager((Project)context2.getProject()).getFileElement(context2.getFile(), MavenDomProjectModel.class);
        if (domFileElement == null) {
            return MavenArtifactCoordinatesHelper.withVersion((MavenDomShortArtifactCoordinates)coords, "");
        }
        DomFileElement domModel = domFileElement;
        GenericDomValue<String> genericDomValue = coords;
        String string = MavenDependencyCompletionUtil.removeDummy(genericDomValue != null && (genericDomValue = genericDomValue.getGroupId()) != null ? genericDomValue.getStringValue() : null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeDummy(...)");
        String groupId = string;
        GenericDomValue<String> genericDomValue2 = coords;
        String string2 = MavenDependencyCompletionUtil.removeDummy(genericDomValue2 != null && (genericDomValue2 = genericDomValue2.getArtifactId()) != null ? genericDomValue2.getStringValue() : null);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"removeDummy(...)");
        String artifactId = string2;
        if (((CharSequence)artifactId).length() > 0 && ((CharSequence)groupId).length() > 0 && coords != null) {
            if (MavenDependencyCompletionUtil.isPlugin(coords)) {
                GenericDomValue<String> managedPlugin = MavenDependencyCompletionUtil.findManagedPlugin((MavenDomProjectModel)domModel.getRootElement(), context2.getProject(), groupId, artifactId);
                Object object = managedPlugin;
                if (object == null || (object = object.getVersion()) == null || (object = object.getStringValue()) == null) {
                    object = "";
                }
                return MavenArtifactCoordinatesHelper.withVersion(coords, object);
            }
            if (!MavenDependencyCompletionUtil.isInsideManagedDependency(coords)) {
                GenericDomValue<String> managed = MavenDependencyCompletionUtil.findManagedDependency((MavenDomProjectModel)domModel.getRootElement(), context2.getProject(), groupId, artifactId);
                Object object = managed;
                if (object == null || (object = object.getVersion()) == null || (object = object.getStringValue()) == null) {
                    object = "";
                }
                return MavenArtifactCoordinatesHelper.withVersion(coords, object);
            }
        }
        return new MavenId(groupId, artifactId, "");
    }

    @JvmStatic
    @NotNull
    public static final MavenId withVersion(@Nullable MavenDomShortArtifactCoordinates coords, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (coords == null) {
            return new MavenId("", "", "");
        }
        return new MavenId(MavenDependencyCompletionUtil.removeDummy(coords.getGroupId().getStringValue()), MavenDependencyCompletionUtil.removeDummy(coords.getArtifactId().getStringValue()), version);
    }
}

