/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.agent.extension;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

final class Configuration {
    private static final String DEFAULT_SERVICE_NAME = "unknown";
    private static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    private static final String JSON_EXPORTER_CONFIGURATION_PROPERTY = "otel.traces.exporter.json.file";
    private static final String EXPORTER_ENABLED_PROPERTY = "otel.traces.exporter.json.file.enabled";
    private static final String EXPORT_LOCATION_PROPERTY = "otel.traces.exporter.json.file.location";

    Configuration() {
    }

    public static boolean isJsonExporterEnabled(@NotNull ConfigProperties config) {
        if (config == null) {
            Configuration.$$$reportNull$$$0(0);
        }
        try {
            return Boolean.TRUE.equals(config.getBoolean(EXPORTER_ENABLED_PROPERTY));
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static String getServiceName(@NotNull ConfigProperties properties) {
        String string;
        if (properties == null) {
            Configuration.$$$reportNull$$$0(1);
        }
        try {
            String serviceName = properties.getString(SERVICE_NAME_PROPERTY);
            if (serviceName == null || serviceName.trim().isEmpty()) {
                return DEFAULT_SERVICE_NAME;
            }
            string = serviceName;
        }
        catch (Exception e) {
            return DEFAULT_SERVICE_NAME;
        }
        if (string == null) {
            Configuration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Path getTargetJsonLocation(@NotNull ConfigProperties config) {
        String location;
        if (config == null) {
            Configuration.$$$reportNull$$$0(3);
        }
        if ((location = config.getString(EXPORT_LOCATION_PROPERTY)) == null) {
            throw new IllegalStateException("The property otel.traces.exporter.json.file.location should not be null!");
        }
        Path path = Paths.get(location, new String[0]);
        if (path == null) {
            Configuration.$$$reportNull$$$0(4);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/diagnostic/telemetry/agent/extension/Configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/diagnostic/telemetry/agent/extension/Configuration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetJsonLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJsonExporterEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getServiceName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetJsonLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

