/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.collections.CollectionsKt;
import kotlin.collections.UCollectionsKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayInput;
import kotlinx.serialization.cbor.internal.CborDecodingException;
import kotlinx.serialization.cbor.internal.CborDecodingExceptionKt;
import kotlinx.serialization.cbor.internal.DecoderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0002J\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0006\u0010\u000f\u001a\u00020\u0005J\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0016\u001a\u00020\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001c\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u001d\u0010\u001bJ1\u0010\u001e\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\rJ\u0019\u0010'\u001a\u00020(2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010+\u001a\u00020\"2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b,\u0010-J'\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00130/2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b0\u00101J\b\u00102\u001a\u00020(H\u0002J\u001b\u00103\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b4\u00105J!\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00132\b\u00107\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0004\b8\u00109J\u001e\u0010:\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0006\u0012\u0004\u0018\u00010<\u0012\u0006\u0012\u0004\u0018\u00010\u00130;J\u0019\u0010=\u001a\u00020<2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b>\u0010?J\b\u0010@\u001a\u00020<H\u0002J\u0014\u0010A\u001a\u00020<*\u00020\u00032\u0006\u0010B\u001a\u00020\tH\u0002J\u0014\u0010C\u001a\u00020(*\u00020\u00032\u0006\u0010D\u001a\u00020\tH\u0002J\u0019\u0010E\u001a\u00020F2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\bG\u0010HJ\u0019\u0010I\u001a\u00020J2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\bK\u0010LJ\b\u0010M\u001a\u00020<H\u0002J\b\u0010N\u001a\u00020OH\u0002J\b\u0010P\u001a\u00020\tH\u0002J\u0017\u0010Q\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\bR\u0010SJ\u0016\u0010T\u001a\u00020\r2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\t0VH\u0002J\b\u0010W\u001a\u00020\u0005H\u0002J\b\u0010X\u001a\u00020\tH\u0002J\b\u0010Y\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lkotlinx/serialization/cbor/internal/CborParser;", "", "input", "Lkotlinx/serialization/cbor/internal/ByteArrayInput;", "verifyObjectTags", "", "<init>", "(Lkotlinx/serialization/cbor/internal/ByteArrayInput;Z)V", "curByte", "", "readByte", "isEof", "skipByte", "", "expected", "isNull", "nextNull", "", "tags", "Lkotlin/ULongArray;", "nextNull-uLth9ew", "([J)Ljava/lang/Void;", "nextBoolean", "nextBoolean-uLth9ew", "([J)Z", "startArray", "startArray-uLth9ew", "([J)I", "startMap", "startMap-uLth9ew", "startSized", "unboundedHeader", "boundedHeaderMask", "collectionType", "", "startSized-kvxxsfM", "([JIILjava/lang/String;)I", "isEnd", "end", "nextByteString", "", "nextByteString-uLth9ew", "([J)[B", "nextString", "nextString-uLth9ew", "([J)Ljava/lang/String;", "nextTaggedString", "Lkotlin/Pair;", "nextTaggedString-uLth9ew", "([J)Lkotlin/Pair;", "readBytes", "processTags", "processTags-_7fx0C0", "([J)[J", "verifyTagsAndThrow", "actual", "verifyTagsAndThrow-EOCRwWE$kotlinx_serialization_cbor", "([J[J)V", "nextTaggedStringOrNumber", "Lkotlin/Triple;", "", "nextNumber", "nextNumber-uLth9ew", "([J)J", "readNumber", "readExact", "bytes", "readExactNBytes", "bytesCount", "nextFloat", "", "nextFloat-uLth9ew", "([J)F", "nextDouble", "", "nextDouble-uLth9ew", "([J)D", "readLong", "readShort", "", "readInt", "skipElement", "skipElement-uLth9ew", "([J)V", "prune", "lengthStack", "", "isIndefinite", "elementLength", "readIndefiniteLengthBytes", "kotlinx-serialization-cbor"})
public final class CborParser {
    @NotNull
    private final ByteArrayInput input;
    private final boolean verifyObjectTags;
    private int curByte;

    public CborParser(@NotNull ByteArrayInput input, boolean verifyObjectTags) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.input = input;
        this.verifyObjectTags = verifyObjectTags;
        this.curByte = -1;
        this.readByte();
    }

    private final int readByte() {
        this.curByte = this.input.read();
        return this.curByte;
    }

    public final boolean isEof() {
        return this.curByte == -1;
    }

    private final void skipByte(int expected) {
        if (this.curByte != expected) {
            throw CborDecodingExceptionKt.CborDecodingException("byte " + CborDecodingExceptionKt.printByte(expected), this.curByte);
        }
        this.readByte();
    }

    public final boolean isNull() {
        return this.curByte == 246 || this.curByte == 160;
    }

    @Nullable
    public final Void nextNull-uLth9ew(@Nullable long[] tags) {
        this.processTags-_7fx0C0(tags);
        if (this.curByte == 246) {
            this.skipByte(246);
        } else if (this.curByte == 160) {
            this.skipByte(160);
        }
        return null;
    }

    public static /* synthetic */ Void nextNull-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextNull-uLth9ew(lArray);
    }

    public final boolean nextBoolean-uLth9ew(@Nullable long[] tags) {
        boolean bl;
        this.processTags-_7fx0C0(tags);
        switch (this.curByte) {
            case 245: {
                bl = true;
                break;
            }
            case 244: {
                bl = false;
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("boolean value", this.curByte);
            }
        }
        boolean ans = bl;
        this.readByte();
        return ans;
    }

    public static /* synthetic */ boolean nextBoolean-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextBoolean-uLth9ew(lArray);
    }

    public final int startArray-uLth9ew(@Nullable long[] tags) {
        return this.startSized-kvxxsfM(tags, 159, 128, "array");
    }

    public static /* synthetic */ int startArray-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.startArray-uLth9ew(lArray);
    }

    public final int startMap-uLth9ew(@Nullable long[] tags) {
        return this.startSized-kvxxsfM(tags, 191, 160, "map");
    }

    public static /* synthetic */ int startMap-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.startMap-uLth9ew(lArray);
    }

    private final int startSized-kvxxsfM(long[] tags, int unboundedHeader, int boundedHeaderMask, String collectionType) {
        this.processTags-_7fx0C0(tags);
        if (this.curByte == unboundedHeader) {
            this.skipByte(unboundedHeader);
            return -1;
        }
        if ((this.curByte & 0xE0) != boundedHeaderMask) {
            throw CborDecodingExceptionKt.CborDecodingException("start of " + collectionType, this.curByte);
        }
        int size = (int)this.readNumber();
        this.readByte();
        return size;
    }

    public final boolean isEnd() {
        return this.curByte == 255;
    }

    public final void end() {
        this.skipByte(255);
    }

    @NotNull
    public final byte[] nextByteString-uLth9ew(@Nullable long[] tags) {
        this.processTags-_7fx0C0(tags);
        if ((this.curByte & 0xE0) != 64) {
            throw CborDecodingExceptionKt.CborDecodingException("start of byte string", this.curByte);
        }
        byte[] arr = this.readBytes();
        this.readByte();
        return arr;
    }

    public static /* synthetic */ byte[] nextByteString-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextByteString-uLth9ew(lArray);
    }

    @NotNull
    public final String nextString-uLth9ew(@Nullable long[] tags) {
        return this.nextTaggedString-uLth9ew(tags).getFirst();
    }

    public static /* synthetic */ String nextString-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextString-uLth9ew(lArray);
    }

    private final Pair<String, ULongArray> nextTaggedString-uLth9ew(long[] tags) {
        long[] collectedTags = this.processTags-_7fx0C0(tags);
        if ((this.curByte & 0xE0) != 96) {
            throw CborDecodingExceptionKt.CborDecodingException("start of string", this.curByte);
        }
        byte[] arr = this.readBytes();
        String ans = StringsKt.decodeToString(arr);
        this.readByte();
        return TuplesKt.to(ans, collectedTags != null ? ULongArray.box-impl(collectedTags) : null);
    }

    private final byte[] readBytes() {
        byte[] byArray;
        if ((this.curByte & 0x1F) == 31) {
            this.readByte();
            byArray = this.readIndefiniteLengthBytes();
        } else {
            int strLen = (int)this.readNumber();
            byArray = this.readExactNBytes(this.input, strLen);
        }
        return byArray;
    }

    private final long[] processTags-_7fx0C0(long[] tags) {
        ULongArray uLongArray;
        long[] it;
        int index = 0;
        List collectedTags = new ArrayList();
        while ((this.curByte & 0xE0) == 192) {
            long readTag = ULong.constructor-impl(this.readNumber());
            ULong uLong = ULong.box-impl(readTag);
            ((Collection)collectedTags).add(uLong);
            if (this.verifyObjectTags) {
                if (tags != null) {
                    it = tags;
                    boolean bl = false;
                    int n = index;
                    index = n + 1;
                    if (n >= ULongArray.getSize-impl(it)) {
                        throw new CborDecodingException("More tags found than the " + ULongArray.getSize-impl(it) + " tags specified");
                    }
                }
            }
            this.readByte();
        }
        long[] lArray = collectedTags.isEmpty() ? null : UCollectionsKt.toULongArray(collectedTags);
        ULongArray uLongArray2 = uLongArray = lArray != null ? ULongArray.box-impl(lArray) : null;
        long[] collected = (long[])(uLongArray2 != null ? uLongArray2.unbox-impl() : null);
        boolean bl = false;
        if (tags != null) {
            it = tags;
            boolean bl2 = false;
            if (this.verifyObjectTags) {
                this.verifyTagsAndThrow-EOCRwWE$kotlinx_serialization_cbor(it, collected);
            } else if (collectedTags.size() < ULongArray.getSize-impl(it) || !Intrinsics.areEqual(collectedTags.subList(0, ULongArray.getSize-impl(it)), UArraysKt.asList-QwZRm1k(it))) {
                throw new CborDecodingException("CBOR tags " + collectedTags + " do not start with specified tags " + ULongArray.toString-impl(it));
            }
        }
        ULongArray uLongArray3 = uLongArray;
        return (long[])(uLongArray3 != null ? uLongArray3.unbox-impl() : null);
    }

    public final void verifyTagsAndThrow-EOCRwWE$kotlinx_serialization_cbor(@NotNull long[] expected, @Nullable long[] actual) {
        Intrinsics.checkNotNullParameter(expected, "expected");
        if (!UArraysKt.contentEquals-lec5QzE(expected, actual)) {
            throw new CborDecodingException("CBOR tags " + (actual != null ? UArraysKt.contentToString-uLth9ew(actual) : null) + " do not match expected tags " + UArraysKt.contentToString-uLth9ew(expected));
        }
    }

    @NotNull
    public final Triple<String, Long, ULongArray> nextTaggedStringOrNumber() {
        long[] collectedTags = this.processTags-_7fx0C0(null);
        if ((this.curByte & 0xE0) == 96) {
            byte[] arr = this.readBytes();
            String ans = StringsKt.decodeToString(arr);
            this.readByte();
            return new Triple<String, Object, ULongArray>(ans, null, collectedTags != null ? ULongArray.box-impl(collectedTags) : null);
        }
        long res = this.readNumber();
        this.readByte();
        return new Triple<Object, Long, ULongArray>(null, res, collectedTags != null ? ULongArray.box-impl(collectedTags) : null);
    }

    public final long nextNumber-uLth9ew(@Nullable long[] tags) {
        this.processTags-_7fx0C0(tags);
        long res = this.readNumber();
        this.readByte();
        return res;
    }

    public static /* synthetic */ long nextNumber-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextNumber-uLth9ew(lArray);
    }

    private final long readNumber() {
        int bytesToRead;
        int value = this.curByte & 0x1F;
        boolean negative = (this.curByte & 0xE0) == 32;
        switch (value) {
            case 24: {
                int n = 1;
                break;
            }
            case 25: {
                int n = 2;
                break;
            }
            case 26: {
                int n = 4;
                break;
            }
            case 27: {
                int n = 8;
                break;
            }
            default: {
                int n = bytesToRead = 0;
            }
        }
        if (bytesToRead == 0) {
            return negative ? -((long)(value + 1)) : (long)value;
        }
        long res = this.readExact(this.input, bytesToRead);
        return negative ? -(res + 1L) : res;
    }

    private final long readExact(ByteArrayInput $this$readExact, int bytes) {
        byte[] arr = this.readExactNBytes($this$readExact, bytes);
        long result = 0L;
        for (int i = 0; i < bytes; ++i) {
            result = result << 8 | (long)(arr[i] & 0xFF);
        }
        return result;
    }

    private final byte[] readExactNBytes(ByteArrayInput $this$readExactNBytes, int bytesCount) {
        if (bytesCount > $this$readExactNBytes.getAvailableBytes()) {
            throw new IllegalStateException(("Unexpected EOF, available " + $this$readExactNBytes.getAvailableBytes() + " bytes, requested: " + bytesCount).toString());
        }
        byte[] array = new byte[bytesCount];
        $this$readExactNBytes.read(array, 0, bytesCount);
        return array;
    }

    public final float nextFloat-uLth9ew(@Nullable long[] tags) {
        float f;
        this.processTags-_7fx0C0(tags);
        switch (this.curByte) {
            case 250: {
                f = Float.intBitsToFloat(this.readInt());
                break;
            }
            case 249: {
                f = DecoderKt.access$floatFromHalfBits(this.readShort());
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("float header", this.curByte);
            }
        }
        float res = f;
        this.readByte();
        return res;
    }

    public static /* synthetic */ float nextFloat-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextFloat-uLth9ew(lArray);
    }

    public final double nextDouble-uLth9ew(@Nullable long[] tags) {
        double d;
        this.processTags-_7fx0C0(tags);
        switch (this.curByte) {
            case 251: {
                d = Double.longBitsToDouble(this.readLong());
                break;
            }
            case 250: {
                d = Float.intBitsToFloat(this.readInt());
                break;
            }
            case 249: {
                d = DecoderKt.access$floatFromHalfBits(this.readShort());
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("double header", this.curByte);
            }
        }
        double res = d;
        this.readByte();
        return res;
    }

    public static /* synthetic */ double nextDouble-uLth9ew$default(CborParser cborParser, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = null;
        }
        return cborParser.nextDouble-uLth9ew(lArray);
    }

    private final long readLong() {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.input.read();
            result = result << 8 | (long)n;
        }
        return result;
    }

    private final short readShort() {
        int highByte = this.input.read();
        int lowByte = this.input.read();
        return (short)(highByte << 8 | lowByte);
    }

    private final int readInt() {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.input.read();
            result = result << 8 | n;
        }
        return result;
    }

    public final void skipElement-uLth9ew(@Nullable long[] tags) {
        List lengthStack = new ArrayList();
        this.processTags-_7fx0C0(tags);
        do {
            if (this.isEof()) {
                throw new CborDecodingException("Unexpected EOF while skipping element");
            }
            if (this.isIndefinite()) {
                lengthStack.add(-1);
            } else if (this.isEnd()) {
                Integer n = (Integer)CollectionsKt.removeLastOrNull(lengthStack);
                int n2 = -1;
                if (n == null || n != n2) {
                    throw CborDecodingExceptionKt.CborDecodingException("next data item", this.curByte);
                }
                this.prune(lengthStack);
            } else {
                int header = this.curByte & 0xE0;
                int length = this.elementLength();
                switch (header) {
                    case 192: {
                        this.readNumber();
                        break;
                    }
                    case 128: 
                    case 160: {
                        if (length > 0) {
                            lengthStack.add(length);
                            break;
                        }
                        this.prune(lengthStack);
                        break;
                    }
                    default: {
                        this.input.skip(length);
                        this.prune(lengthStack);
                    }
                }
            }
            this.readByte();
        } while (!((Collection)lengthStack).isEmpty());
    }

    private final void prune(List<Integer> lengthStack) {
        block4: for (int i = CollectionsKt.getLastIndex(lengthStack); -1 < i; --i) {
            switch (((Number)lengthStack.get(i)).intValue()) {
                case -1: {
                    break;
                }
                case 1: {
                    ((Number)lengthStack.remove(i)).intValue();
                    continue block4;
                }
                default: {
                    lengthStack.set(i, ((Number)lengthStack.get(i)).intValue() - 1);
                    break;
                }
            }
            break;
        }
    }

    private final boolean isIndefinite() {
        int majorType = this.curByte & 0xE0;
        int value = this.curByte & 0x1F;
        return value == 31 && (majorType == 128 || majorType == 160 || majorType == 64 || majorType == 96);
    }

    private final int elementLength() {
        int n;
        int majorType = this.curByte & 0xE0;
        int additionalInformation = this.curByte & 0x1F;
        block0 : switch (majorType) {
            case 64: 
            case 96: 
            case 128: {
                n = (int)this.readNumber();
                break;
            }
            case 160: {
                n = (int)this.readNumber() * 2;
                break;
            }
            default: {
                switch (additionalInformation) {
                    case 24: {
                        n = 1;
                        break block0;
                    }
                    case 25: {
                        n = 2;
                        break block0;
                    }
                    case 26: {
                        n = 4;
                        break block0;
                    }
                    case 27: {
                        n = 8;
                        break block0;
                    }
                }
                n = 0;
            }
        }
        return n;
    }

    private final byte[] readIndefiniteLengthBytes() {
        List byteStrings = new ArrayList();
        do {
            byteStrings.add(this.readBytes());
            this.readByte();
        } while (!this.isEnd());
        return DecoderKt.access$flatten(byteStrings);
    }
}

