/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.plugins.OrderedNodePlacementPlugin;

public class SimplePlacementFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    @Override
    public PlacementPlugin createPluginInstance() {
        return new SimplePlacementPlugin();
    }

    private static class SameCollWeightedNode
    extends OrderedNodePlacementPlugin.WeightedNode {
        private static final int SAME_COL_MULT = 5;
        private static final int SAME_SHARD_MULT = 1000;
        public Map<String, Integer> collectionReplicas = new HashMap<String, Integer>();
        public int totalWeight = 0;

        SameCollWeightedNode(Node node) {
            super(node);
        }

        @Override
        public int calcWeight() {
            return this.totalWeight;
        }

        @Override
        public int calcRelevantWeightWithReplica(Replica replica) {
            int colReplicaCount = this.collectionReplicas.getOrDefault(replica.getShard().getCollection().getName(), 0);
            int shardReplicaCount = this.getReplicasForShardOnNode(replica.getShard()).size();
            return this.getAllReplicaCount() + 1 + colReplicaCount * 5 + shardReplicaCount * 1000;
        }

        @Override
        public boolean canAddReplica(Replica replica) {
            return true;
        }

        @Override
        protected boolean addProjectedReplicaWeights(Replica replica) {
            int colReplicaCountWith = this.collectionReplicas.merge(replica.getShard().getCollection().getName(), 1, Integer::sum);
            int shardReplicaCountWith = this.getReplicasForShardOnNode(replica.getShard()).size();
            this.totalWeight += this.addedWeightOfAdditionalReplica(colReplicaCountWith - 1, shardReplicaCountWith - 1);
            return false;
        }

        @Override
        protected void initReplicaWeights(Replica replica) {
            this.addProjectedReplicaWeights(replica);
        }

        @Override
        protected void removeProjectedReplicaWeights(Replica replica) {
            Integer colReplicaCountWithout = Optional.ofNullable(this.collectionReplicas.computeIfPresent(replica.getShard().getCollection().getName(), (k, v) -> v - 1)).orElse(0);
            int shardReplicaCountWithout = this.getReplicasForShardOnNode(replica.getShard()).size();
            this.totalWeight -= this.addedWeightOfAdditionalReplica(colReplicaCountWithout, shardReplicaCountWithout);
        }

        private int addedWeightOfAdditionalReplica(int colReplicaCountWithout, int shardReplicaCountWithout) {
            int additionalWeight = 1;
            if (colReplicaCountWithout > 0) {
                additionalWeight += 5 * (colReplicaCountWithout * 2 - 1);
            }
            if (shardReplicaCountWithout > 0) {
                additionalWeight += 1000 * (colReplicaCountWithout * 2 - 1);
            }
            return additionalWeight;
        }
    }

    public static class SimplePlacementPlugin
    extends OrderedNodePlacementPlugin {
        @Override
        protected Map<Node, OrderedNodePlacementPlugin.WeightedNode> getBaseWeightedNodes(PlacementContext placementContext, Set<Node> nodes, Iterable<SolrCollection> relevantCollections, boolean skipNodesWithErrors) {
            HashMap<Node, OrderedNodePlacementPlugin.WeightedNode> nodeVsShardCount = new HashMap<Node, OrderedNodePlacementPlugin.WeightedNode>();
            for (Node n : nodes) {
                nodeVsShardCount.computeIfAbsent(n, SameCollWeightedNode::new);
            }
            return nodeVsShardCount;
        }
    }
}

