/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTree;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/listControl/TreeMouseMotionListener;", "Ljava/awt/event/MouseMotionAdapter;", "tree", "Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTree;", "<init>", "(Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTree;)V", "myLastSelectedIndex", "", "myIsEngaged", "", "myLastMouseLocation", "Ljava/awt/Point;", "isMouseMoved", "location", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.rd.ui"})
final class TreeMouseMotionListener
extends MouseMotionAdapter {
    @NotNull
    private final BeTree tree;
    private int myLastSelectedIndex;
    private boolean myIsEngaged;
    @Nullable
    private Point myLastMouseLocation;

    public TreeMouseMotionListener(@NotNull BeTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.tree = tree;
        this.myLastSelectedIndex = -2;
    }

    private final boolean isMouseMoved(Point location) {
        if (this.myLastMouseLocation == null) {
            this.myLastMouseLocation = location;
            return false;
        }
        return !Intrinsics.areEqual((Object)this.myLastMouseLocation, (Object)location);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point point = e.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        if (!this.isMouseMoved(point)) {
            return;
        }
        Point point2 = e.getPoint();
        if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && this.tree.getSelectionCount() <= 1) {
            int index = this.tree.getClosestRowForLocation(point2.x, point2.y);
            if (index != this.myLastSelectedIndex) {
                this.tree.putClientProperty("byMouseEvent", true);
                this.tree.setSelectionRow(index);
                this.tree.putClientProperty("byMouseEvent", false);
                this.myLastSelectedIndex = index;
            }
        } else {
            this.myIsEngaged = true;
        }
    }
}

