/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RemovableView;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.run.ui.AggregatesTabInfoProvider;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.EditMaximizedViewRequestPlace;
import com.intellij.database.run.ui.RecordView;
import com.intellij.database.run.ui.RecordViewInfoProvider;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.database.run.ui.ValueEditorTab;
import com.intellij.database.run.ui.ValueTabInfoProvider;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\n\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u001a\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u001cJ\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\u0006\u0010\"\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/intellij/database/run/ui/EditMaximizedView;", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lcom/intellij/database/datagrid/RemovableView;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "disposed", "", "runnerTabs", "com/intellij/database/run/ui/EditMaximizedView$runnerTabs$1", "Lcom/intellij/database/run/ui/EditMaximizedView$runnerTabs$1;", "viewComponent", "Ljavax/swing/JComponent;", "getViewComponent", "()Ljavax/swing/JComponent;", "tabInfoProviders", "", "Lcom/intellij/database/run/ui/TabInfoProvider;", "preferedFocusComponent", "getPreferedFocusComponent", "getAggregateViewer", "Lcom/intellij/database/run/ui/CellViewer;", "getRecordViewer", "Lcom/intellij/database/run/ui/RecordView;", "open", "", "select", "Lkotlin/Function1;", "reportOpenProvider", "provider", "dispose", "isDisposed", "onRemoved", "getCurrentTabInfoProvider", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nEditMaximizedView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditMaximizedView.kt\ncom/intellij/database/run/ui/EditMaximizedView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n774#2:164\n865#2,2:165\n1068#2:167\n1563#2:168\n1634#2,3:169\n1#3:172\n*S KotlinDebug\n*F\n+ 1 EditMaximizedView.kt\ncom/intellij/database/run/ui/EditMaximizedView\n*L\n35#1:164\n35#1:165,2\n36#1:167\n36#1:168\n36#1:169,3\n*E\n"})
public final class EditMaximizedView
implements CheckedDisposable,
RemovableView {
    @NotNull
    private final DataGrid grid;
    private volatile boolean disposed;
    @NotNull
    private final runnerTabs.1 runnerTabs;
    @NotNull
    private final JComponent viewComponent;
    @NotNull
    private final List<TabInfoProvider> tabInfoProviders;

    /*
     * WARNING - void declaration
     */
    public EditMaximizedView(@NotNull DataGrid grid) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ValueEditorTab it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        Object object = this.grid.getProject();
        DataGrid dataGrid = this.grid;
        this.runnerTabs = new JBRunnerTabs(this, (Project)object, dataGrid){
            final /* synthetic */ EditMaximizedView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (Disposable)$super_call_param$2);
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                sink.set(EditMaximizedViewKt.EDIT_MAXIMIZED_KEY, (Object)this.this$0);
            }
        };
        this.viewComponent = (JComponent)((Object)this.runnerTabs);
        object = ValueEditorTab.Companion.getEP().getExtensionList();
        EditMaximizedView editMaximizedView = this;
        boolean $i$f$filter = false;
        void var4_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ValueEditorTab)element$iv$iv;
            boolean bl = false;
            if (!it.applicable(this.grid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ValueEditorTab it = (ValueEditorTab)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (ValueEditorTab)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tab;
            it = (ValueEditorTab)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(tab.createTabInfoProvider(this.grid, (Function0<Unit>)((Function0)() -> EditMaximizedView.tabInfoProviders$lambda$4$lambda$3(this))));
        }
        editMaximizedView.tabInfoProviders = (List)destination$iv$iv;
        Border $i$f$map22 = this.runnerTabs.getComponent().getBorder();
        JBRunnerTabs.JBRunnerTabsBorder jBRunnerTabsBorder = $i$f$map22 instanceof JBRunnerTabs.JBRunnerTabsBorder ? (JBRunnerTabs.JBRunnerTabsBorder)$i$f$map22 : null;
        if (jBRunnerTabsBorder != null) {
            jBRunnerTabsBorder.setSideMask(0);
        }
        for (TabInfoProvider provider : this.tabInfoProviders) {
            Disposer.register((Disposable)((Disposable)this), (Disposable)provider);
            TabInfoProvider.update$default(provider, null, 1, null);
            this.runnerTabs.addTab(provider.getTabInfo());
        }
        this.runnerTabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                TabInfoProvider oldProvider;
                Object v1;
                TabInfoProvider provider;
                block6: {
                    Object object;
                    Object object22;
                    block5: {
                        Iterable iterable = tabInfoProviders;
                        for (Object object22 : iterable) {
                            TabInfoProvider it = (TabInfoProvider)object22;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getTabInfo(), (Object)newSelection)) continue;
                            object = object22;
                            break block5;
                        }
                        object = null;
                    }
                    provider = (TabInfoProvider)object;
                    Iterable iterable = tabInfoProviders;
                    object22 = iterable.iterator();
                    while (object22.hasNext()) {
                        Object e = object22.next();
                        TabInfoProvider it = (TabInfoProvider)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getTabInfo(), (Object)oldSelection)) continue;
                        v1 = e;
                        break block6;
                    }
                    v1 = null;
                }
                TabInfoProvider tabInfoProvider = oldProvider = (TabInfoProvider)v1;
                if (tabInfoProvider != null) {
                    tabInfoProvider.onTabLeave();
                }
                TabInfoProvider tabInfoProvider2 = provider;
                if (tabInfoProvider2 != null) {
                    tabInfoProvider2.onTabEnter();
                }
                if (provider == null) {
                    return;
                }
                this.reportOpenProvider(provider);
            }
        }, (Disposable)this);
        this.grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onContentChanged(DataGrid dataGrid, GridRequestSource.RequestPlace place) {
                Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                ApplicationManager.getApplication().invokeLater(() -> 2.onContentChanged$lambda$1(this, place));
            }

            @Override
            public void onCellLanguageChanged(ModelIndex<GridColumn> columnIdx, Language language) {
                Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                Iterable $this$forEach$iv = tabInfoProviders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TabInfoProvider it = (TabInfoProvider)element$iv;
                    boolean bl = false;
                    TabInfoProvider.update$default(it, null, 1, null);
                }
            }

            @Override
            public void onCellDisplayTypeChanged(ModelIndex<GridColumn> columnIdx, DisplayType type) {
                Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Iterable $this$forEach$iv = tabInfoProviders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TabInfoProvider it = (TabInfoProvider)element$iv;
                    boolean bl = false;
                    TabInfoProvider.update$default(it, null, 1, null);
                }
            }

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                Iterable $this$forEach$iv = tabInfoProviders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TabInfoProvider it = (TabInfoProvider)element$iv;
                    boolean bl = false;
                    it.update(UpdateEvent.SelectionChanged.INSTANCE);
                }
            }

            @Override
            public void onValueEdited(DataGrid dataGrid, Object value) {
                ApplicationManager.getApplication().invokeLater(() -> 2.onValueEdited$lambda$6(this, value));
            }

            private static final void onContentChanged$lambda$1(EditMaximizedView this$0, GridRequestSource.RequestPlace $place) {
                if (this$0.isDisposed()) {
                    return;
                }
                Iterable $this$forEach$iv = this$0.tabInfoProviders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TabInfoProvider provider = (TabInfoProvider)element$iv;
                    boolean bl = false;
                    if ($place instanceof EditMaximizedViewRequestPlace && Intrinsics.areEqual((Object)((EditMaximizedViewRequestPlace)$place).getViewer(), (Object)provider.getViewer()) && Intrinsics.areEqual((Object)((EditMaximizedViewRequestPlace)$place).getGrid(), (Object)this$0.grid)) continue;
                    provider.update(UpdateEvent.ContentChanged.INSTANCE);
                }
            }

            private static final void onValueEdited$lambda$6(EditMaximizedView this$0, Object $value) {
                Iterable $this$forEach$iv = this$0.tabInfoProviders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TabInfoProvider it = (TabInfoProvider)element$iv;
                    boolean bl = false;
                    it.update(new UpdateEvent.ValueChanged($value));
                }
            }
        }, (Disposable)this);
        this.grid.putUserData(EditMaximizedViewKt.EDIT_MAXIMIZED_GRID_KEY, this);
    }

    @Override
    @NotNull
    public JComponent getViewComponent() {
        return this.viewComponent;
    }

    @Nullable
    public final JComponent getPreferedFocusComponent() {
        TabInfo tabInfo = this.runnerTabs.getSelectedInfo();
        return tabInfo != null ? tabInfo.getPreferredFocusableComponent() : null;
    }

    @Nullable
    public final CellViewer getAggregateViewer() {
        TabInfoProvider tabInfoProvider;
        Object v0;
        block1: {
            Iterable iterable = this.tabInfoProviders;
            for (Object t : iterable) {
                TabInfoProvider tabInfoProvider2 = (TabInfoProvider)t;
                boolean bl = false;
                if (!(tabInfoProvider2 instanceof AggregatesTabInfoProvider)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        TabInfoProvider tabInfoProvider3 = tabInfoProvider = (TabInfoProvider)v0;
        return tabInfoProvider3 != null ? tabInfoProvider3.getViewer() : null;
    }

    @Nullable
    public final RecordView getRecordViewer() {
        Object v0;
        block1: {
            Iterable iterable = this.tabInfoProviders;
            for (Object t : iterable) {
                TabInfoProvider it = (TabInfoProvider)t;
                boolean bl = false;
                if (!(it instanceof RecordViewInfoProvider)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        TabInfoProvider tabInfoProvider = v0;
        CellViewer cellViewer = tabInfoProvider != null ? tabInfoProvider.getViewer() : null;
        return cellViewer instanceof RecordView ? (RecordView)cellViewer : null;
    }

    public final void open(@NotNull Function1<? super TabInfoProvider, Boolean> select) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(select, (String)"select");
            Iterable iterable = this.tabInfoProviders;
            for (Object t : iterable) {
                TabInfoProvider tabInfoProvider = (TabInfoProvider)t;
                boolean bl = false;
                if (!((Boolean)select.invoke((Object)tabInfoProvider)).booleanValue()) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        TabInfoProvider tabInfoProvider = v0;
        if (tabInfoProvider != null) {
            TabInfoProvider current = this.getCurrentTabInfoProvider();
            current.onTabLeave();
            tabInfoProvider.onTabEnter();
            if (Intrinsics.areEqual((Object)tabInfoProvider, (Object)current)) {
                this.reportOpenProvider(tabInfoProvider);
            }
            this.runnerTabs.select(tabInfoProvider.getTabInfo(), true);
        }
    }

    private final void reportOpenProvider(TabInfoProvider provider) {
        DataGrid.ActiveGridListener listener = GridUtil.activeGridListener();
        TabInfoProvider tabInfoProvider = provider;
        if (tabInfoProvider instanceof ValueTabInfoProvider) {
            listener.onValueEditorOpened(this.grid);
        } else if (tabInfoProvider instanceof AggregatesTabInfoProvider) {
            listener.onAggregateViewOpened(this.grid);
        } else if (tabInfoProvider instanceof RecordViewInfoProvider) {
            listener.onRecordViewOpened(this.grid);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.grid.putUserData(EditMaximizedViewKt.EDIT_MAXIMIZED_GRID_KEY, null);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void onRemoved() {
        Disposer.dispose((Disposable)((Disposable)this));
    }

    @NotNull
    public final TabInfoProvider getCurrentTabInfoProvider() {
        Object v0;
        block1: {
            Iterable iterable = this.tabInfoProviders;
            for (Object t : iterable) {
                TabInfoProvider it = (TabInfoProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.runnerTabs.getSelectedInfo(), (Object)it.getTabInfo())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    private static final boolean tabInfoProviders$lambda$4$lambda$3$lambda$2(TabInfoProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ValueTabInfoProvider;
    }

    private static final Unit tabInfoProviders$lambda$4$lambda$3(EditMaximizedView this$0) {
        this$0.open((Function1<? super TabInfoProvider, Boolean>)((Function1)EditMaximizedView::tabInfoProviders$lambda$4$lambda$3$lambda$2));
        return Unit.INSTANCE;
    }
}

