/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.util.Arrays;

public abstract class OctetArrayBCPGKey
extends BCPGObject
implements BCPGKey {
    private final byte[] key;

    OctetArrayBCPGKey(int n, BCPGInputStream bCPGInputStream) throws IOException {
        this.key = new byte[n];
        bCPGInputStream.readFully(this.key);
    }

    OctetArrayBCPGKey(int n, byte[] byArray) {
        if (byArray.length != n) {
            throw new IllegalArgumentException("unexpected key encoding length: expected " + n + " bytes, got " + byArray.length);
        }
        this.key = new byte[n];
        System.arraycopy(byArray, 0, this.key, 0, n);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.write(this.key);
    }

    public byte[] getKey() {
        return Arrays.clone(this.key);
    }
}

