/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerHost;
import com.intellij.xdebugger.impl.DefaultRunToCursorService;
import com.jetbrains.codeWithMe.model.DebuggerModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.LightSuspendContextModel;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientLuxRunToCursorState;", "Lcom/intellij/xdebugger/impl/DefaultRunToCursorService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isLuxDebugger", "", "()Z", "shouldShowInlay", "isAtExecution", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "canRunToCursor", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "(Lcom/intellij/openapi/editor/Editor;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getContext", "Lcom/jetbrains/codeWithMe/model/LightSuspendContextModel;", "intellij.platform.execution.frontend.split"})
public final class ThinClientLuxRunToCursorState
extends DefaultRunToCursorService {
    public ThinClientLuxRunToCursorState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    private final boolean isLuxDebugger() {
        return ThinClientDebuggerHost.Companion.useLuxDebugger();
    }

    public boolean shouldShowInlay() {
        if (!this.isLuxDebugger()) {
            return super.shouldShowInlay();
        }
        return this.getContext(this.getProject()) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtExecution(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isLuxDebugger()) {
            return super.isAtExecution(file, line);
        }
        if (!(file instanceof IProtocolVirtualFile)) {
            return false;
        }
        LightSuspendContextModel lightSuspendContextModel = this.getContext(this.getProject());
        if (lightSuspendContextModel == null) {
            return false;
        }
        LightSuspendContextModel context = lightSuspendContextModel;
        if (!Intrinsics.areEqual((Object)((IProtocolVirtualFile)file).getFileId(), (Object)context.getCurrentFile())) return false;
        Integer n = context.getCurrentLine();
        if (n == null) return false;
        if (line != n) return false;
        return true;
    }

    @Nullable
    public Object canRunToCursor(@NotNull Editor editor, int lineNumber, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)true);
    }

    private final LightSuspendContextModel getContext(Project project) {
        return (LightSuspendContextModel)DebuggerModel_GeneratedKt.getDebuggerModel((Solution)IdeBackend.Companion.getInstance(project).getSolution()).getLightSuspendContext().getValue();
    }
}

