/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.llmInstaller.api.AiToolWindowService;
import com.intellij.llmInstaller.ui.wizard.LLMInstallerWizardPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ%\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u0010\u001a\u00070\r\u00a2\u0006\u0002\b\u000eR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/llmInstaller/ui/LLMInstallerUIUtil;", "", "<init>", "()V", "minimumToolWindowContentWidth", "", "getMinimumToolWindowContentWidth", "()I", "getLLMInstallerWizardPanel", "Lcom/intellij/llmInstaller/ui/wizard/LLMInstallerWizardPanel;", "project", "Lcom/intellij/openapi/project/Project;", "appendTextAndComment", "", "Lorg/jetbrains/annotations/Nls;", "text", "comment", "intellij.llmInstaller"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLLMInstallerUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMInstallerUIUtil.kt\ncom/intellij/llmInstaller/ui/LLMInstallerUIUtil\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,150:1\n40#2,3:151\n*S KotlinDebug\n*F\n+ 1 LLMInstallerUIUtil.kt\ncom/intellij/llmInstaller/ui/LLMInstallerUIUtil\n*L\n43#1:151,3\n*E\n"})
public final class LLMInstallerUIUtil {
    @NotNull
    public static final LLMInstallerUIUtil INSTANCE = new LLMInstallerUIUtil();

    private LLMInstallerUIUtil() {
    }

    public final int getMinimumToolWindowContentWidth() {
        return Registry.Companion.intValue("llm.ai.assistant.toolwindow.content.minimum.width", 280);
    }

    @Nullable
    public final LLMInstallerWizardPanel getLLMInstallerWizardPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean $i$f$service = false;
        Class<AiToolWindowService> serviceClass$iv = AiToolWindowService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ToolWindow toolWindow = ((AiToolWindowService)object).getToolWindow(project);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Content[] contentArray = toolWindow2.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Content content2 = (Content)ArraysKt.firstOrNull((Object[])contentArray);
        JComponent jComponent = content2 != null ? content2.getComponent() : null;
        return jComponent instanceof LLMInstallerWizardPanel ? (LLMInstallerWizardPanel)jComponent : null;
    }

    @NotNull
    public final String appendTextAndComment(@NotNull String text2, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        String string = ColorUtil.toHex((Color)JBUI.CurrentTheme.Popup.mnemonicForeground());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String color = string;
        return "<html>" + text2 + " <font color='#" + color + "'>" + comment + "</font>";
    }
}

