/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.options;

import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterRenderer;
import com.intellij.cwm.plugin.common.control.CodeWithMeColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.jetbrains.codeWithMe.model.RdUserId;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RemoteCaretData;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00011B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0015\u0010\f\u001a\u00020\r*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0004J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/cwm/plugin/common/options/CodeWithMeColorsPage;", "Lcom/intellij/openapi/options/colors/ColorSettingsPage;", "Lcom/intellij/psi/codeStyle/DisplayPrioritySortable;", "Lcom/intellij/openapi/options/colors/ColorSettingsPage$PreviewCustomizer;", "<init>", "()V", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getDisplayName", "", "getIcon", "Ljavax/swing/Icon;", "to", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "ourAdditionalHighlighting", "", "getAttributeDescriptors", "", "()[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "getColorDescriptors", "Lcom/intellij/openapi/options/colors/ColorDescriptor;", "()[Lcom/intellij/openapi/options/colors/ColorDescriptor;", "getHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "getDemoText", "getAdditionalHighlightingTagToDescriptorMap", "getPreviewEditorCustomizer", "getPriority", "Lcom/intellij/psi/codeStyle/DisplayPriority;", "addCustomizations", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "selectedKeyName", "removeCustomizations", "", "getCustomizationAt", "location", "Ljava/awt/Point;", "getRangeAndAddBorder", "i", "", "isMarker", "", "highlightersData", "", "Lcom/intellij/cwm/plugin/common/options/CodeWithMeColorsPage$UserHighlighterData;", "UserHighlighterData", "intellij.cwm.plugin.common"})
public final class CodeWithMeColorsPage
implements ColorSettingsPage,
DisplayPrioritySortable,
ColorSettingsPage.PreviewCustomizer {
    @NotNull
    private final SequentialLifetimes lifetimes = new SequentialLifetimes(Lifetime.Companion.getEternal());
    @NotNull
    private final Map<String, TextAttributesKey> ourAdditionalHighlighting;
    @NotNull
    private final List<UserHighlighterData> highlightersData;

    public CodeWithMeColorsPage() {
        Object[] objectArray = new Pair[]{new Pair((Object)"propertyKey", (Object)DefaultLanguageHighlighterColors.INSTANCE_FIELD), new Pair((Object)"string", (Object)DefaultLanguageHighlighterColors.STRING), new Pair((Object)"number", (Object)DefaultLanguageHighlighterColors.NUMBER), new Pair((Object)"keyword", (Object)DefaultLanguageHighlighterColors.KEYWORD), new Pair((Object)"line_comment", (Object)DefaultLanguageHighlighterColors.LINE_COMMENT), new Pair((Object)"block_comment", (Object)DefaultLanguageHighlighterColors.BLOCK_COMMENT), new Pair((Object)"colon", (Object)DefaultLanguageHighlighterColors.SEMICOLON), new Pair((Object)"comma", (Object)DefaultLanguageHighlighterColors.COMMA), new Pair((Object)"esc", (Object)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE)};
        this.ourAdditionalHighlighting = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new UserHighlighterData[]{new UserHighlighterData(CodeWithMeColors.INSTANCE.getUSER_1_MARKER(), CodeWithMeColors.INSTANCE.getUSER_1_SELECTION(), 12, 4), new UserHighlighterData(CodeWithMeColors.INSTANCE.getUSER_2_MARKER(), CodeWithMeColors.INSTANCE.getUSER_2_SELECTION(), 80, 5), new UserHighlighterData(CodeWithMeColors.INSTANCE.getUSER_3_MARKER(), CodeWithMeColors.INSTANCE.getUSER_3_SELECTION(), 145, 2), new UserHighlighterData(CodeWithMeColors.INSTANCE.getUSER_4_MARKER(), CodeWithMeColors.INSTANCE.getUSER_4_SELECTION(), 168, 7), new UserHighlighterData(CodeWithMeColors.INSTANCE.getUSER_5_MARKER(), CodeWithMeColors.INSTANCE.getUSER_5_SELECTION(), 207, 12), new UserHighlighterData(CodeWithMeColors.INSTANCE.getUSER_6_MARKER(), CodeWithMeColors.INSTANCE.getUSER_6_SELECTION(), 256, 3)};
        this.highlightersData = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getDisplayName() {
        return PlatformSplitBundle.INSTANCE.message("product.name", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public final AttributesDescriptor to(@NotNull String $this$to, @NotNull TextAttributesKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$to, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new AttributesDescriptor($this$to, key);
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        AttributesDescriptor[] attributesDescriptorArray = new AttributesDescriptor[]{this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user1.marker", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_1_MARKER()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user2.marker", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_2_MARKER()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user3.marker", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_3_MARKER()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user4.marker", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_4_MARKER()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user5.marker", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_5_MARKER()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user6.marker", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_6_MARKER()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user1.selection", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_1_SELECTION()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user2.selection", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_2_SELECTION()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user3.selection", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_3_SELECTION()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user4.selection", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_4_SELECTION()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user5.selection", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_5_SELECTION()), this.to(CodeWithMeCommonBundle.INSTANCE.message("color.settings.user6.selection", new Object[0]), CodeWithMeColors.INSTANCE.getUSER_6_SELECTION())};
        return attributesDescriptorArray;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        Intrinsics.checkNotNullExpressionValue((Object)ColorDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return (SyntaxHighlighter)new PlainSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        return "{\n  <line_comment>// JSON file as an example</line_comment>\n  <block_comment>/* Some block comment */</block_comment>\n  <propertyKey>\"keywords\"</propertyKey><colon>:</colon>  [<keyword>true</keyword><comma>,</comma> <keyword>false</keyword><comma>,</comma> <keyword>null</keyword>]<comma>,</comma>\n  <propertyKey>\"strings\"</propertyKey><colon>:</colon> {\n    <propertyKey>\"no escapes\"</propertyKey><colon>:</colon>  <string>\"pseudopolinomiality\"</string><comma>,</comma>\n    <propertyKey>\"escapes\"</propertyKey><colon>:</colon>  <string>\"C-style<esc>\\r\\n</esc> and unicode<esc>\\u0021</esc>\"</string>\n  }<comma>,</comma>\n  <propertyKey>\"some numbers\"</propertyKey><colon>:</colon>  [\n    <number>42</number><comma>,</comma>\n    <number>-0.0e-0</number><comma>,</comma>\n    <number>6.626e-34</number>\n  ] \n}";
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return this.ourAdditionalHighlighting;
    }

    @NotNull
    public ColorSettingsPage.PreviewCustomizer getPreviewEditorCustomizer() {
        return this;
    }

    @NotNull
    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }

    @Nullable
    public TextRange addCustomizations(@NotNull Editor editor, @Nullable String selectedKeyName) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Lifetime lifetime = this.lifetimes.next().getLifetime();
        int n = CodeWithMeColors.INSTANCE.getBACKGROUNDS().size();
        for (int i = 0; i < n; ++i) {
            UserHighlighterData data = this.highlightersData.get(i);
            int offset = data.getOffset();
            int len = data.getLen();
            RemoteCaretData remoteCaretData = new RemoteCaretData(new RdUserModel(new RdUserId(String.valueOf(i)), "User" + i, i), true, null, true, 0, false);
            MarkupModel markupModel = editor.getMarkupModel();
            Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
            MarkupModelEx markup = (MarkupModelEx)markupModel;
            Object object = markup.addRangeHighlighterAndChangeAttributes(null, offset, offset + len, 5999, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> CodeWithMeColorsPage.addCustomizations$lambda$1(arg_0 -> CodeWithMeColorsPage.addCustomizations$lambda$0(len, remoteCaretData, data, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"addRangeHighlighterAndChangeAttributes(...)");
            RangeHighlighterEx highlighter = object;
            object = selectedKeyName;
            if (Intrinsics.areEqual((Object)object, (Object)data.getMarkerKey().getExternalName())) {
                this.getRangeAndAddBorder(editor, i, true);
            } else if (Intrinsics.areEqual((Object)object, (Object)data.getSelectionKey().getExternalName())) {
                this.getRangeAndAddBorder(editor, i, false);
            }
            lifetime.onTermination(() -> CodeWithMeColorsPage.addCustomizations$lambda$2(highlighter));
        }
        return null;
    }

    public void removeCustomizations(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.lifetimes.terminateCurrent();
    }

    @Nullable
    public String getCustomizationAt(@NotNull Editor editor, @NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(location));
        for (int i = 0; i < 6; ++i) {
            int iOffset = this.highlightersData.get(i).getOffset();
            if (offset == iOffset) {
                return this.highlightersData.get(i).getMarkerKey().getExternalName();
            }
            boolean bl = iOffset <= offset ? offset <= iOffset + this.highlightersData.get(i).getLen() : false;
            if (!bl) continue;
            return this.highlightersData.get(i).getSelectionKey().getExternalName();
        }
        return null;
    }

    private final TextRange getRangeAndAddBorder(Editor editor, int i, boolean isMarker) {
        Map displayText = ColorSettingsUtil.keyToDisplayTextMap((ColorSettingsPage)this);
        int offset = this.highlightersData.get(i).getOffset();
        int len = !isMarker ? this.highlightersData.get(i).getLen() : 0;
        TextRange range = new TextRange(offset, offset + len);
        new HighlightData(range.getStartOffset(), range.getEndOffset(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES).addHighlToView(editor, editor.getColorsScheme(), displayText);
        return range;
    }

    private static final Unit addCustomizations$lambda$0(int $len, RemoteCaretData $remoteCaretData, UserHighlighterData $data, RangeHighlighterEx h) {
        if ($len == 0) {
            RangeMarkerImpl rangeMarkerImpl = h instanceof RangeMarkerImpl ? (RangeMarkerImpl)h : null;
            if (rangeMarkerImpl != null) {
                rangeMarkerImpl.setStickingToRight(true);
            }
        }
        h.setCustomRenderer((CustomHighlighterRenderer)new RemoteCaretHighlighterRenderer($remoteCaretData));
        h.setTextAttributesKey($data.getSelectionKey());
        return Unit.INSTANCE;
    }

    private static final void addCustomizations$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addCustomizations$lambda$2(RangeHighlighterEx $highlighter) {
        $highlighter.dispose();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u0012\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/cwm/plugin/common/options/CodeWithMeColorsPage$UserHighlighterData;", "", "markerKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "selectionKey", "offset", "", "len", "<init>", "(Lcom/intellij/openapi/editor/colors/TextAttributesKey;Lcom/intellij/openapi/editor/colors/TextAttributesKey;II)V", "getMarkerKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getSelectionKey", "getOffset", "()I", "getLen", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cwm.plugin.common"})
    public static final class UserHighlighterData {
        @NotNull
        private final TextAttributesKey markerKey;
        @NotNull
        private final TextAttributesKey selectionKey;
        private final int offset;
        private final int len;

        public UserHighlighterData(@NotNull TextAttributesKey markerKey, @NotNull TextAttributesKey selectionKey, int offset, int len) {
            Intrinsics.checkNotNullParameter((Object)markerKey, (String)"markerKey");
            Intrinsics.checkNotNullParameter((Object)selectionKey, (String)"selectionKey");
            this.markerKey = markerKey;
            this.selectionKey = selectionKey;
            this.offset = offset;
            this.len = len;
        }

        @NotNull
        public final TextAttributesKey getMarkerKey() {
            return this.markerKey;
        }

        @NotNull
        public final TextAttributesKey getSelectionKey() {
            return this.selectionKey;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getLen() {
            return this.len;
        }

        @NotNull
        public final TextAttributesKey component1() {
            return this.markerKey;
        }

        @NotNull
        public final TextAttributesKey component2() {
            return this.selectionKey;
        }

        public final int component3() {
            return this.offset;
        }

        public final int component4() {
            return this.len;
        }

        @NotNull
        public final UserHighlighterData copy(@NotNull TextAttributesKey markerKey, @NotNull TextAttributesKey selectionKey, int offset, int len) {
            Intrinsics.checkNotNullParameter((Object)markerKey, (String)"markerKey");
            Intrinsics.checkNotNullParameter((Object)selectionKey, (String)"selectionKey");
            return new UserHighlighterData(markerKey, selectionKey, offset, len);
        }

        public static /* synthetic */ UserHighlighterData copy$default(UserHighlighterData userHighlighterData, TextAttributesKey textAttributesKey, TextAttributesKey textAttributesKey2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                textAttributesKey = userHighlighterData.markerKey;
            }
            if ((n3 & 2) != 0) {
                textAttributesKey2 = userHighlighterData.selectionKey;
            }
            if ((n3 & 4) != 0) {
                n = userHighlighterData.offset;
            }
            if ((n3 & 8) != 0) {
                n2 = userHighlighterData.len;
            }
            return userHighlighterData.copy(textAttributesKey, textAttributesKey2, n, n2);
        }

        @NotNull
        public String toString() {
            return "UserHighlighterData(markerKey=" + this.markerKey + ", selectionKey=" + this.selectionKey + ", offset=" + this.offset + ", len=" + this.len + ")";
        }

        public int hashCode() {
            int result = this.markerKey.hashCode();
            result = result * 31 + this.selectionKey.hashCode();
            result = result * 31 + Integer.hashCode(this.offset);
            result = result * 31 + Integer.hashCode(this.len);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserHighlighterData)) {
                return false;
            }
            UserHighlighterData userHighlighterData = (UserHighlighterData)other;
            if (!Intrinsics.areEqual((Object)this.markerKey, (Object)userHighlighterData.markerKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.selectionKey, (Object)userHighlighterData.selectionKey)) {
                return false;
            }
            if (this.offset != userHighlighterData.offset) {
                return false;
            }
            return this.len == userHighlighterData.len;
        }
    }
}

