/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.util.ast.DoNotCollectText;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class TextCollectingVisitor {
    SequenceBuilder out;
    private final NodeVisitor myVisitor;
    final HashSet<Class<?>> myLineBreakNodes;

    protected static Class<?>[] concatArrays(Class<?>[] ... classes) {
        int total = 0;
        for (Class<?>[] classList : classes) {
            total += classList.length;
        }
        Class[] result = new Class[total];
        int index = 0;
        for (Class<?>[] classList : classes) {
            System.arraycopy(classList, 0, result, index, classList.length);
            index += classList.length;
        }
        return result;
    }

    public TextCollectingVisitor(Class<?> ... lineBreakNodes) {
        this.myLineBreakNodes = lineBreakNodes.length == 0 ? null : new HashSet(Arrays.asList(lineBreakNodes));
        this.myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler<Text>(Text.class, this::visit), new VisitHandler<TextBase>(TextBase.class, this::visit), new VisitHandler<HtmlEntity>(HtmlEntity.class, this::visit), new VisitHandler<SoftLineBreak>(SoftLineBreak.class, this::visit), new VisitHandler<Paragraph>(Paragraph.class, this::visit), new VisitHandler<HardLineBreak>(HardLineBreak.class, this::visit)}){

            @Override
            public void processNode(@NotNull Node node, boolean withChildren, @NotNull BiConsumer<Node, Visitor<Node>> processor) {
                Visitor visitor = (Visitor)this.getAction(node);
                if (visitor != null) {
                    processor.accept(node, visitor);
                } else {
                    this.processChildren(node, processor);
                    if (TextCollectingVisitor.this.myLineBreakNodes != null && TextCollectingVisitor.this.myLineBreakNodes.contains(node.getClass()) && !node.isOrDescendantOfType(DoNotCollectText.class)) {
                        TextCollectingVisitor.this.out.add("\n");
                    }
                }
            }
        };
    }

    public String getText() {
        return this.out.toString();
    }

    public void collect(Node node) {
        this.out = SequenceBuilder.emptyBuilder(node.getChars());
        this.myVisitor.visit(node);
    }

    public String collectAndGetText(Node node) {
        this.collect(node);
        return this.out.toString();
    }

    public BasedSequence collectAndGetSequence(Node node) {
        this.collect(node);
        return this.out.toSequence();
    }

    private void visit(Paragraph node) {
        if (!node.isOrDescendantOfType(DoNotCollectText.class)) {
            if (!this.out.isEmpty()) {
                this.out.add("\n\n");
            }
            this.myVisitor.visitChildren(node);
        }
    }

    private void visit(SoftLineBreak node) {
        this.out.add(node.getChars());
    }

    private void visit(HardLineBreak node) {
        BasedSequence chars = node.getChars();
        this.out.add(chars.subSequence(chars.length() - 1, chars.length()));
    }

    private void visit(HtmlEntity node) {
        this.out.add(node.getChars().unescape());
    }

    private void visit(Text node) {
        if (!node.isOrDescendantOfType(DoNotCollectText.class)) {
            this.out.add(node.getChars());
        }
    }

    private void visit(TextBase node) {
        this.out.add(node.getChars());
    }
}

