/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.newmatch.CascadedStyle;
import com.openhtmltopdf.css.style.CalculatedStyle;
import java.util.ArrayList;
import java.util.List;

public class StyleTracker {
    private final List<CascadedStyle> _styles;
    private static final StyleTracker EMPTY_INSTANCE = new StyleTracker(0);

    public StyleTracker(int size) {
        this._styles = new ArrayList<CascadedStyle>(size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((StyleTracker)obj).getStyles().equals(this.getStyles());
    }

    public StyleTracker withStyle(CascadedStyle style) {
        StyleTracker tracker = new StyleTracker(this.getStyles().size() + 1);
        tracker._styles.addAll(this.getStyles());
        tracker._styles.add(style);
        return tracker;
    }

    public StyleTracker withOutLast() {
        if (this._styles.isEmpty()) {
            return this;
        }
        if (this._styles.size() == 1) {
            return EMPTY_INSTANCE;
        }
        StyleTracker tracker = new StyleTracker(this.getStyles().size() - 1);
        tracker._styles.addAll(this.getStyles().subList(0, this.getStyles().size() - 1));
        return tracker;
    }

    public boolean hasStyles() {
        return !this._styles.isEmpty();
    }

    public static StyleTracker withNoStyles() {
        return EMPTY_INSTANCE;
    }

    public CalculatedStyle deriveAll(CalculatedStyle start) {
        CalculatedStyle result = start;
        for (CascadedStyle style : this.getStyles()) {
            result = result.deriveStyle(style);
        }
        return result;
    }

    private List<CascadedStyle> getStyles() {
        return this._styles;
    }
}

