/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.ref;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.actions.ref.GitSingleRefAction;
import git4idea.branch.GitBrancher;
import git4idea.config.GitSharedSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J.\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/actions/ref/GitMergeRefAction;", "Lgit4idea/actions/ref/GitSingleRefAction;", "Lgit4idea/GitReference;", "<init>", "()V", "isEnabledForRef", "", "ref", "repositories", "", "Lgit4idea/repo/GitRepository;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "reference", "updateIfEnabledAndVisible", "deleteOnMerge", "Lgit4idea/branch/GitBrancher$DeleteOnMergeOption;", "intellij.vcs.git"})
public final class GitMergeRefAction
extends GitSingleRefAction<GitReference> {
    public GitMergeRefAction() {
        Supplier supplier = GitBundle.messagePointer((String)"branches.merge.into.current", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        super(supplier);
    }

    @Override
    protected boolean isEnabledForRef(@NotNull GitReference ref, @NotNull List<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        return !GitSingleRefAction.Companion.isCurrentRefInAnyRepo$intellij_vcs_git(ref, repositories);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitReference reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        GitBrancher.getInstance(project).merge(reference, this.deleteOnMerge(reference, project), repositories);
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitReference reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        Object[] objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, reference.getName()), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories)};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setText(GitBundle.message((String)"branches.merge.into", (Object[])objectArray));
        objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(reference.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories)};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message((String)"branches.merge.into", (Object[])objectArray));
        objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(reference.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories)};
        GitBranchPopupActions.addTooltipText($this$updateIfEnabledAndVisible_u24lambda_u240, GitBundle.message((String)"branches.merge.into", (Object[])objectArray));
    }

    private final GitBrancher.DeleteOnMergeOption deleteOnMerge(GitReference reference, Project project) {
        return reference instanceof GitBranch && !((GitBranch)reference).isRemote() && !GitSharedSettings.getInstance(project).isBranchProtected(reference.getName()) ? GitBrancher.DeleteOnMergeOption.PROPOSE : GitBrancher.DeleteOnMergeOption.NOTHING;
    }
}

