/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.HierarchicalReader;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.openapi.Disposable;
import com.intellij.util.containers.JBIterable;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridModel<Row, Column> {
    public boolean isValidRowIdx(@NotNull ModelIndex<Row> var1);

    public boolean isValidColumnIdx(@NotNull ModelIndex<Column> var1);

    @Nullable
    public Object getValueAt(ModelIndex<Row> var1, ModelIndex<Column> var2);

    public boolean allValuesEqualTo(@NotNull ModelIndexSet<Row> var1, @NotNull ModelIndexSet<Column> var2, @Nullable Object var3);

    @Nullable
    default public HierarchicalReader getHierarchicalReader() {
        return null;
    }

    @Nullable
    public Row getRow(@NotNull ModelIndex<Row> var1);

    @Nullable
    public Column getColumn(@NotNull ModelIndex<Column> var1);

    @NotNull
    public List<Row> getRows(@NotNull ModelIndexSet<Row> var1);

    @NotNull
    public List<Column> getColumns(@NotNull ModelIndexSet<Column> var1);

    @NotNull
    public List<Column> getColumns();

    @NotNull
    public JBIterable<Column> getColumnsAsIterable();

    @NotNull
    public JBIterable<Column> getColumnsAsIterable(@NotNull ModelIndexSet<Column> var1);

    @NotNull
    public List<Row> getRows();

    @NotNull
    public ModelIndexSet<Column> getColumnIndices();

    @NotNull
    public ModelIndexSet<Row> getRowIndices();

    public int getColumnCount();

    public int getRowCount();

    public boolean isUpdatingNow();

    public void addListener(@NotNull Listener<Row, Column> var1, @NotNull Disposable var2);

    public boolean hasListeners();

    default public List<Column> getAllColumnsForExtraction(int ... selectedColumns) {
        return this.getColumns();
    }

    public static interface Listener<Row, Column>
    extends EventListener {
        public void columnsAdded(ModelIndexSet<Column> var1);

        public void columnsRemoved(ModelIndexSet<Column> var1);

        public void rowsAdded(ModelIndexSet<Row> var1);

        public void rowsRemoved(ModelIndexSet<Row> var1);

        public void cellsUpdated(ModelIndexSet<Row> var1, ModelIndexSet<Column> var2, @Nullable GridRequestSource.RequestPlace var3);

        default public void afterLastRowAdded() {
        }
    }
}

