/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.auth.UserIdentifier;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.GetAccountInfoRequest;
import com.google.firebase.internal.NonNull;

public final class ProviderIdentifier
extends UserIdentifier {
    private final String providerId;
    private final String providerUid;

    public ProviderIdentifier(@NonNull String providerId, @NonNull String providerUid) {
        UserRecord.checkProvider(providerId, providerUid);
        this.providerId = providerId;
        this.providerUid = providerUid;
    }

    @Override
    public String toString() {
        return "ProviderIdentifier(" + this.providerId + ", " + this.providerUid + ")";
    }

    @Override
    void populate(@NonNull GetAccountInfoRequest payload) {
        payload.addFederatedUserId(this.providerId, this.providerUid);
    }

    @Override
    boolean matches(@NonNull UserRecord userRecord) {
        for (UserInfo userInfo : userRecord.getProviderData()) {
            if (!this.providerId.equals(userInfo.getProviderId()) || !this.providerUid.equals(userInfo.getUid())) continue;
            return true;
        }
        return false;
    }
}

