/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.traccar.storage.QueryIgnore;

public final class ReflectionCache {
    private static final Map<Key, Map<String, PropertyMethod>> CACHE = new ConcurrentHashMap<Key, Map<String, PropertyMethod>>();

    private ReflectionCache() {
    }

    public static Map<String, PropertyMethod> getProperties(Class<?> clazz, String type) {
        return CACHE.computeIfAbsent(new Key(clazz, type), key -> {
            HashMap<String, PropertyMethod> properties = new HashMap<String, PropertyMethod>();
            for (Method method : clazz.getMethods()) {
                int parameterCount = type.equals("set") ? 1 : 0;
                Class<?>[] parameters = method.getParameterTypes();
                if (!method.getName().startsWith(type) || parameters.length != parameterCount || method.getName().equals("getClass")) continue;
                String name = Introspector.decapitalize(method.getName().substring(3));
                properties.put(name, new PropertyMethod(method, method.isAnnotationPresent(QueryIgnore.class)));
            }
            return properties;
        });
    }

    private record Key(Class<?> clazz, String type) {
    }

    public record PropertyMethod(Method method, boolean queryIgnore) {
    }
}

