/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.QueryScope;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.index.QueryExpressionIndex;
import org.h2.index.RecursiveIndex;
import org.h2.index.RegularQueryExpressionIndex;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.QueryExpressionTable;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.ParserUtil;

public final class CTE
extends QueryExpressionTable {
    private final String querySQL;
    private final boolean recursive;
    private final QueryScope queryScope;
    private final ArrayList<Parameter> originalParameters;
    private ResultInterface recursiveResult;

    public CTE(String string, Query query, String string2, ArrayList<Parameter> arrayList, Column[] columnArray, SessionLocal sessionLocal, boolean bl, QueryScope queryScope) {
        super(sessionLocal.getDatabase().getMainSchema(), 0, string);
        this.setTemporary(true);
        this.queryScope = queryScope;
        this.querySQL = string2;
        this.recursive = bl;
        this.originalParameters = arrayList;
        this.tables = new ArrayList<Table>(query.getTables());
        this.setColumns(this.initColumns(sessionLocal, columnArray, query, false));
        this.viewQuery = query;
    }

    @Override
    protected QueryExpressionIndex createIndex(SessionLocal sessionLocal, int[] nArray) {
        return this.recursive ? new RecursiveIndex(this, this.querySQL, this.originalParameters, sessionLocal) : new RegularQueryExpressionIndex(this, this.querySQL, this.originalParameters, sessionLocal, nArray);
    }

    @Override
    public Query getTopQuery() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        return ParserUtil.quoteIdentifier(stringBuilder, this.getName(), n);
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    @Override
    public QueryScope getQueryScope() {
        return this.queryScope;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive) {
            return false;
        }
        return super.isDeterministic();
    }

    public void setRecursiveResult(ResultInterface resultInterface) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = resultInterface;
    }

    public ResultInterface getRecursiveResult() {
        return this.recursiveResult;
    }
}

