// Code generated by 'go generate'; DO NOT EDIT.

package winenv

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modMDMRegistration = windows.NewLazySystemDLL("MDMRegistration.dll")
	modkernel32        = windows.NewLazySystemDLL("kernel32.dll")

	procIsDeviceRegisteredWithManagement = modMDMRegistration.NewProc("IsDeviceRegisteredWithManagement")
	procVerSetConditionMask              = modkernel32.NewProc("VerSetConditionMask")
	procVerifyVersionInfoW               = modkernel32.NewProc("VerifyVersionInfoW")
)

func isDeviceRegisteredWithManagement(isMDMRegistered *bool, upnBufLen uint32, upnBuf *uint16) (hr int32, err error) {
	err = procIsDeviceRegisteredWithManagement.Find()
	if err != nil {
		return
	}
	var _p0 uint32
	if *isMDMRegistered {
		_p0 = 1
	}
	r0, _, e1 := syscall.Syscall(procIsDeviceRegisteredWithManagement.Addr(), 3, uintptr(unsafe.Pointer(&_p0)), uintptr(upnBufLen), uintptr(unsafe.Pointer(upnBuf)))
	*isMDMRegistered = _p0 != 0
	hr = int32(r0)
	if hr == 0 {
		err = errnoErr(e1)
	}
	return
}

func verSetConditionMask(condMask verCondMask, typ verTypeMask, cond verCond) (res verCondMask) {
	r0, _, _ := syscall.Syscall(procVerSetConditionMask.Addr(), 3, uintptr(condMask), uintptr(typ), uintptr(cond))
	res = verCondMask(r0)
	return
}

func verifyVersionInfo(verInfo *osVersionInfoEx, typ verTypeMask, cond verCondMask) (res bool) {
	r0, _, _ := syscall.Syscall(procVerifyVersionInfoW.Addr(), 3, uintptr(unsafe.Pointer(verInfo)), uintptr(typ), uintptr(cond))
	res = r0 != 0
	return
}
