// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: venue.sql

package ondeck

import (
	"context"

	"github.com/lib/pq"
)

const createVenue = `-- name: CreateVenue :one
INSERT INTO venue (
    slug,
    name,
    city,
    created_at,
    spotify_playlist,
    status,
    statuses,
    tags
) VALUES (
    $1,
    $2,
    $3,
    NOW(),
    $4,
    $5,
    $6,
    $7
) RETURNING id
`

type CreateVenueParams struct {
	Slug            string   `json:"slug"`
	Name            string   `json:"name"`
	City            string   `json:"city"`
	SpotifyPlaylist string   `json:"spotify_playlist"`
	Status          Status   `json:"status"`
	Statuses        []Status `json:"statuses"`
	Tags            []string `json:"tags"`
}

func (q *Queries) CreateVenue(ctx context.Context, arg CreateVenueParams) (int32, error) {
	row := q.queryRow(ctx, q.createVenueStmt, createVenue,
		arg.Slug,
		arg.Name,
		arg.City,
		arg.SpotifyPlaylist,
		arg.Status,
		pq.Array(arg.Statuses),
		pq.Array(arg.Tags),
	)
	var id int32
	err := row.Scan(&id)
	return id, err
}

const deleteVenue = `-- name: DeleteVenue :exec
DELETE FROM venue
WHERE slug = $1 AND slug = $1
`

func (q *Queries) DeleteVenue(ctx context.Context, slug string) error {
	_, err := q.exec(ctx, q.deleteVenueStmt, deleteVenue, slug)
	return err
}

const getVenue = `-- name: GetVenue :one
SELECT id, status, statuses, slug, name, city, spotify_playlist, songkick_id, tags, created_at
FROM venue
WHERE slug = $1 AND city = $2
`

type GetVenueParams struct {
	Slug string `json:"slug"`
	City string `json:"city"`
}

func (q *Queries) GetVenue(ctx context.Context, arg GetVenueParams) (Venue, error) {
	row := q.queryRow(ctx, q.getVenueStmt, getVenue, arg.Slug, arg.City)
	var i Venue
	err := row.Scan(
		&i.ID,
		&i.Status,
		pq.Array(&i.Statuses),
		&i.Slug,
		&i.Name,
		&i.City,
		&i.SpotifyPlaylist,
		&i.SongkickID,
		pq.Array(&i.Tags),
		&i.CreatedAt,
	)
	return i, err
}

const listVenues = `-- name: ListVenues :many
SELECT id, status, statuses, slug, name, city, spotify_playlist, songkick_id, tags, created_at
FROM venue
WHERE city = $1
ORDER BY name
`

func (q *Queries) ListVenues(ctx context.Context, city string) ([]Venue, error) {
	rows, err := q.query(ctx, q.listVenuesStmt, listVenues, city)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Venue
	for rows.Next() {
		var i Venue
		if err := rows.Scan(
			&i.ID,
			&i.Status,
			pq.Array(&i.Statuses),
			&i.Slug,
			&i.Name,
			&i.City,
			&i.SpotifyPlaylist,
			&i.SongkickID,
			pq.Array(&i.Tags),
			&i.CreatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateVenueName = `-- name: UpdateVenueName :one
UPDATE venue
SET name = $2
WHERE slug = $1
RETURNING id
`

type UpdateVenueNameParams struct {
	Slug string `json:"slug"`
	Name string `json:"name"`
}

func (q *Queries) UpdateVenueName(ctx context.Context, arg UpdateVenueNameParams) (int32, error) {
	row := q.queryRow(ctx, q.updateVenueNameStmt, updateVenueName, arg.Slug, arg.Name)
	var id int32
	err := row.Scan(&id)
	return id, err
}

const venueCountByCity = `-- name: VenueCountByCity :many
SELECT
    city,
    count(*)
FROM venue
GROUP BY 1
ORDER BY 1
`

type VenueCountByCityRow struct {
	City  string `json:"city"`
	Count int64  `json:"count"`
}

func (q *Queries) VenueCountByCity(ctx context.Context) ([]VenueCountByCityRow, error) {
	rows, err := q.query(ctx, q.venueCountByCityStmt, venueCountByCity)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []VenueCountByCityRow
	for rows.Next() {
		var i VenueCountByCityRow
		if err := rows.Scan(&i.City, &i.Count); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}
