## RabbitMQ 3.13.7

RabbitMQ `3.13.7` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

This upgrade is **highly recommended** to all users currently on earlier `3.13.x` series and
in particular between `3.13.3` and `3.13.5`, inclusive.

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * Streams recover better from certain node process failures that may leave behind orphaned segment files
   (that is, segment files that do not have a corresponding index file) or index files without a corresponding
   segment file.

   Kudos to @sysupbda for providing detailed reproduction steps and verifying the fix in the affected environment.

   GitHub issue: [#12073](https://github.com/rabbitmq/rabbitmq-server/pull/12073)

 * Config file [peer discovery](https://www.rabbitmq.com/docs/cluster-formation) now logs warnings for certain common user mistakes.

   GitHub issues: [#11586](https://github.com/rabbitmq/rabbitmq-server/issues/11586), [#11898](https://github.com/rabbitmq/rabbitmq-server/pull/11898)

 * Queue declaration operations now return more useful errors when Khepri is enabled and there's only a minority
   of nodes online.

   GitHub issues: [#12020](https://github.com/rabbitmq/rabbitmq-server/pull/12020), [#11991](https://github.com/rabbitmq/rabbitmq-server/pull/11991)

 * Logging is now more defensive around exception handling. Previously a (very rare) logger exception could
   lead to the `amq.rabbitmq.log` handler and exchange to be removed.

   Contributed by @gomoripeti.

   GitHub issue: [#12107](https://github.com/rabbitmq/rabbitmq-server/pull/12107)

 * `rabbitmq-upgrade revive` unintentionally tried to perform operations on replicas that are not local to the node.
   This could result in an exceptions some of which were not handled and the command failed.
   Re-running the command usually helped.

   GitHub issue: [#12038](https://github.com/rabbitmq/rabbitmq-server/pull/12038)


#### Enhancements

 * Enabling an experimental feature flag now involves an explicit confirmation.

   GitHub issue: [#12059](https://github.com/rabbitmq/rabbitmq-server/pull/12059)

 * Khepri projections are registered in a safer manner during node boot.

   GitHub issue: [#11837](https://github.com/rabbitmq/rabbitmq-server/pull/11837)


### MQTT

#### Bug Fixes

 * Clients that use JWT tokens are now disconnected when their token expires. Previously all newly attempted
   operations with an expired token would be rejected but a completely passive connection was not closed.

   GitHub issue: [#11869](https://github.com/rabbitmq/rabbitmq-server/pull/11869)

#### Enhancements

 * Connection that provide incorrect credentials now closed with a delay, just like for several
   other protocols supported by RabbitMQ, as a throttling mechanism.

   GitHub issue: [#11906](https://github.com/rabbitmq/rabbitmq-server/pull/11906)


### CLI Tools

#### Bug Fixes

 * When the Khepri feature flag is not enabled, `rabbitmq-diagnostics metadata_store_status` will not try to retrieve
   and display its status.

   GitHub issue: [#12103](https://github.com/rabbitmq/rabbitmq-server/pull/12103)

#### Enhancements

 * `rabbitmq-upgrade await_quorum_plus_one` now produces more log messages when the operation times out.
   When Khepri is enabled, it now also treats Khepri as a critical Raft-based component that may depend on replica quorum
   just like queues and streams do.

   GitHub issue: [#12117](https://github.com/rabbitmq/rabbitmq-server/pull/12117)


### Management Plugin

#### Bug Fixes

 * When no virtual host limits are set, the limits collection was returned as a JSON array (and not a JSON object)
   by `GET /api/vhost-limits`.

   GitHub issue: [#12084](https://github.com/rabbitmq/rabbitmq-server/pull/12084)

#### Enhancements

 * `GET /api/queues/quorum/{vhost}/{name}/status` is a new endpoint that allows clients to retrieve several key quorum queue
   replica and Raft metrics.

   Contributed by @SimonUnge.

   GitHub issue: [#12072](https://github.com/rabbitmq/rabbitmq-server/pull/12072)


### Shovel Plugin

#### Bug Fixes

 * `GET /api/shovels/{vhost}/{name}` now correctly returns a single shovel instead of all shovels in the target
   virtual host.

   GitHub issue: [#12040](https://github.com/rabbitmq/rabbitmq-server/issues/12040)


### Consistent Hashing Exchange Plugin

#### Bug Fixes

 * For an exchange declared with a `hash-header`, publishing failed with an exception when the client (usually unintentionally)
   did not set that header.

   GitHub issue: [#11808](https://github.com/rabbitmq/rabbitmq-server/pull/11808)


### Dependency Changes

 * Osiris was [upgraded to `1.8.3`](https://github.com/rabbitmq/osiris/releases)
 * Cuttlefish was [upgraded to `3.4.0`](https://github.com/Kyorai/cuttlefish/releases)
 * `observer_cli` was [upgraded to `1.7.5`](https://github.com/zhongwencool/observer_cli/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.7.tar.xz`
instead of the source tarball produced by GitHub.
