/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.RetentionRuleCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListRetentionRulesResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private String opcNextPage;
    private RetentionRuleCollection retentionRuleCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public RetentionRuleCollection getRetentionRuleCollection() {
        return this.retentionRuleCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcClientRequestId", "opcNextPage", "retentionRuleCollection"})
    private ListRetentionRulesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcClientRequestId, String opcNextPage, RetentionRuleCollection retentionRuleCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.opcNextPage = opcNextPage;
        this.retentionRuleCollection = retentionRuleCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",retentionRuleCollection=").append(String.valueOf((Object)this.retentionRuleCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRetentionRulesResponse)) {
            return false;
        }
        ListRetentionRulesResponse other = (ListRetentionRulesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.retentionRuleCollection, (Object)other.retentionRuleCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.retentionRuleCollection == null ? 43 : this.retentionRuleCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListRetentionRulesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcClientRequestId;
        private String opcNextPage;
        private RetentionRuleCollection retentionRuleCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder retentionRuleCollection(RetentionRuleCollection retentionRuleCollection) {
            this.retentionRuleCollection = retentionRuleCollection;
            return this;
        }

        public Builder copy(ListRetentionRulesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.retentionRuleCollection(o.getRetentionRuleCollection());
            return this;
        }

        public ListRetentionRulesResponse build() {
            return new ListRetentionRulesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcClientRequestId, this.opcNextPage, this.retentionRuleCollection);
        }
    }
}

