/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco.archive;

import java.io.File;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.archive.CommonsUnzip;
import org.openide.windows.InputOutput;

public class JDKCommonsUnzip
extends CommonsUnzip {
    @Override
    public void uncompress(File zip, File targetDir, InputOutput io) throws IOException {
        super.uncompress(zip, targetDir, io);
        File bin = JDKCommonsUnzip.findBin(targetDir);
        if (bin != null) {
            io.getOut().println("Making sure java is executable.");
            for (File exe : bin.listFiles()) {
                if (!exe.isFile()) continue;
                exe.setExecutable(true);
            }
        }
        io.getOut().println("Done.");
    }

    public static @Nullable File findBin(File outputDir) {
        for (File f : outputDir.listFiles()) {
            if (!f.isDirectory() || !f.getName().equals("bin")) continue;
            return f;
        }
        for (File f : outputDir.listFiles()) {
            File sub;
            if (!f.isDirectory() || (sub = JDKCommonsUnzip.findBin(f)) == null) continue;
            return sub;
        }
        return null;
    }
}

