/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.debugging;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JToggleButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class ToggleDebuggingAction
extends BaseAction
implements Presenter.Toolbar,
ContextAwareAction {
    public static final String toggleDebuggingAction = "toggle-debugging-action";
    static final long serialVersionUID = 0L;
    static final Set<Document> debuggingEnabled = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    static final Set<ToggleDebuggingAction> actions = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private JEditorPane pane;
    private JToggleButton toggleButton;

    public ToggleDebuggingAction() {
        super(toggleDebuggingAction);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/hints/declarative/resources/toggle-debugging.png", (boolean)false));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public ToggleDebuggingAction(JEditorPane pane) {
        this();
        assert (pane != null);
        this.pane = pane;
        actions.add(this);
        this.updateState();
    }

    private void updateState() {
        if (this.pane != null && this.toggleButton != null) {
            boolean debugging = debuggingEnabled.contains(this.pane.getDocument());
            this.toggleButton.setSelected(debugging);
            this.toggleButton.setContentAreaFilled(debugging);
            this.toggleButton.setBorderPainted(debugging);
        }
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null && !Boolean.TRUE.equals(target.getClientProperty("AsTextField"))) {
            Document doc = target.getDocument();
            if (debuggingEnabled.contains(doc)) {
                debuggingEnabled.remove(doc);
            } else {
                debuggingEnabled.add(doc);
            }
            for (ToggleDebuggingAction a : actions) {
                a.updateState();
            }
        }
    }

    public Component getToolbarPresenter() {
        this.toggleButton = new JToggleButton();
        this.toggleButton.putClientProperty("hideActionText", Boolean.TRUE);
        this.toggleButton.setIcon((Icon)this.getValue("SmallIcon"));
        this.toggleButton.setAction((Action)((Object)this));
        return this.toggleButton;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        JEditorPane pane = (JEditorPane)actionContext.lookup(JEditorPane.class);
        if (pane != null) {
            return new ToggleDebuggingAction(pane);
        }
        return this;
    }

    protected Class getShortDescriptionBundleClass() {
        return ToggleDebuggingAction.class;
    }
}

