/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewLicensePanel
extends JPanel {
    private NotificationLineSupport nls;
    private final POMModel model;
    private DialogDescriptor dd;
    private JScrollPane jScrollPane1;
    private JLabel lblKnown;
    private JLabel lblName;
    private JLabel lblUrl;
    private JList lstKnown;
    private JTextField txtName;
    private JTextField txtUrl;

    NewLicensePanel(POMModel model) {
        this.initComponents();
        this.model = model;
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewLicensePanel.this.checkFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewLicensePanel.this.checkFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewLicensePanel.this.checkFields();
            }
        });
        this.lstKnown.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (NewLicensePanel.this.lstKnown.getSelectedValue() != null) {
                    Tuple tup = (Tuple)NewLicensePanel.this.lstKnown.getSelectedValue();
                    NewLicensePanel.this.txtName.setText(tup.dn);
                    NewLicensePanel.this.txtUrl.setText(tup.url);
                }
            }
        });
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblUrl = new JLabel();
        this.txtUrl = new JTextField();
        this.lblKnown = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstKnown = new JList();
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(NewLicensePanel.class, (String)"NewLicensePanel.lblName.text"));
        this.lblUrl.setLabelFor(this.txtUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblUrl, (String)NbBundle.getMessage(NewLicensePanel.class, (String)"NewLicensePanel.lblUrl.text"));
        this.lblKnown.setLabelFor(this.lstKnown);
        Mnemonics.setLocalizedText((JLabel)this.lblKnown, (String)NbBundle.getMessage(NewLicensePanel.class, (String)"NewLicensePanel.lblKnown.text"));
        this.jScrollPane1.setViewportView(this.lstKnown);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblName).addComponent(this.lblUrl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtUrl).addComponent(this.txtName))).addGroup(layout.createSequentialGroup().addComponent(this.lblKnown).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName).addComponent(this.txtName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUrl).addComponent(this.txtUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblKnown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addContainerGap(82, Short.MAX_VALUE)));
    }

    void attachDialogDisplayer(DialogDescriptor dd) {
        this.dd = dd;
        dd.setValid(false);
        this.nls = dd.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dd.createNotificationLineSupport();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
        DefaultListModel<Tuple> dlm = new DefaultListModel<Tuple>();
        FileObject root = FileUtil.getConfigFile((String)"Templates/Licenses");
        if (root != null) {
            for (FileObject lic : root.getChildren()) {
                String url = (String)lic.getAttribute("mavenLicenseURL");
                if (url == null) continue;
                String dn = (String)lic.getAttribute("displayName");
                if (dn == null && (dn = lic.getName()).startsWith("license-")) {
                    dn = dn.substring("license-".length());
                }
                Tuple tup = new Tuple(url.replaceFirst(" .+", ""), dn);
                dlm.addElement(tup);
            }
        }
        this.lstKnown.setModel(dlm);
    }

    String getLicenseName() {
        return this.txtName.getText().trim();
    }

    String getLicenseUrl() {
        return this.txtUrl.getText().trim();
    }

    private void checkFields() {
        if (this.getLicenseUrl().isEmpty() && this.getLicenseName().isEmpty()) {
            this.nls.setWarningMessage("Both license name and url cannot be empty.");
            this.dd.setValid(false);
        } else {
            this.nls.clearMessages();
            this.dd.setValid(true);
        }
    }

    private static class Tuple {
        final String url;
        final String dn;

        private Tuple(String url, String dn) {
            this.url = url;
            this.dn = dn;
        }

        public String toString() {
            return this.dn;
        }
    }
}

