/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.spi.FailureDataDisplayerImpl;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.impl.HudsonFailureDisplayer;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class ShowFailures
extends AbstractAction
implements ContextAwareAction {
    private static ShowFailures INSTANCE = null;
    private final Lookup context;

    public static ShowFailures getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShowFailures();
        }
        return INSTANCE;
    }

    public ShowFailures() {
        this(Utilities.actionsGlobalContext());
    }

    private ShowFailures(Lookup context) {
        this.putValue("Name", Bundle.ShowFailures_label());
        this.context = context;
    }

    private boolean canShowFailures(HudsonJobBuild build, HudsonMavenModuleBuild module) {
        if (module == null && !HudsonJobBuild.Result.UNSTABLE.equals((Object)build.getResult())) {
            return false;
        }
        if (module != null) {
            boolean failed = false;
            switch (module.getColor()) {
                case yellow: 
                case yellow_anime: {
                    failed = true;
                }
            }
            if (!failed) {
                return false;
            }
        }
        return build.canShowFailures();
    }

    private List<HudsonMavenModuleBuild> getExtraModuleBuilds(HudsonJobBuild build) {
        LinkedList<HudsonMavenModuleBuild> result = new LinkedList<HudsonMavenModuleBuild>();
        Collection alreadyIncludedBuilds = this.context.lookupAll(HudsonMavenModuleBuild.class);
        HashSet<String> alreadyIncludedURLs = new HashSet<String>(alreadyIncludedBuilds.size());
        for (HudsonMavenModuleBuild b : alreadyIncludedBuilds) {
            alreadyIncludedURLs.add(b.getUrl());
        }
        for (HudsonMavenModuleBuild m : build.getMavenModules()) {
            if (alreadyIncludedURLs.contains(m.getUrl())) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        for (HudsonJobBuild job : this.context.lookupAll(HudsonJobBuild.class)) {
            if (!this.canShowFailures(job, null)) continue;
            return true;
        }
        for (HudsonMavenModuleBuild module : this.context.lookupAll(HudsonMavenModuleBuild.class)) {
            if (!this.canShowFailures(module.getBuild(), module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (HudsonJobBuild job : this.context.lookupAll(HudsonJobBuild.class)) {
            this.showFailures(job, null);
        }
        for (HudsonMavenModuleBuild module : this.context.lookupAll(HudsonMavenModuleBuild.class)) {
            this.showFailures(module.getBuild(), module);
        }
    }

    private void showFailures(HudsonJobBuild build, HudsonMavenModuleBuild moduleBuild) {
        if (!this.canShowFailures(build, moduleBuild)) {
            return;
        }
        if (moduleBuild != null) {
            if (moduleBuild.canShowFailures()) {
                moduleBuild.showFailures((FailureDataDisplayerImpl)new HudsonFailureDisplayer(moduleBuild));
            }
        } else if (build.canShowFailures()) {
            if (build.getMavenModules().isEmpty()) {
                build.showFailures((FailureDataDisplayerImpl)new HudsonFailureDisplayer(build));
            } else {
                for (HudsonMavenModuleBuild extraModule : this.getExtraModuleBuilds(build)) {
                    extraModule.showFailures((FailureDataDisplayerImpl)new HudsonFailureDisplayer(extraModule));
                }
            }
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ShowFailures(actionContext);
    }
}

