/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.webmvc.editor.AddBeanPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddBeanPanelVisual
extends JPanel {
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    private boolean dialogOK = false;
    private AddBeanPanel panel;
    private FileObject fileObject;
    private final AtomicBoolean classFound = new AtomicBoolean(false);
    private static final RequestProcessor RP = new RequestProcessor();
    private JTextField classNameTextField;
    private JTextField idTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel scanningLabel;

    public AddBeanPanelVisual(AddBeanPanel panel) {
        this.panel = panel;
        this.fileObject = NbEditorUtilities.getFileObject((Document)panel.getDocument());
        this.initComponents();
        this.scanningLabel.setVisible(false);
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                AddBeanPanelVisual.this.validateInput();
            }
        });
        this.classNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                AddBeanPanelVisual.this.validateInput();
            }
        });
    }

    public boolean showDialog() {
        String id = this.panel.getId();
        String className = this.panel.getClassName();
        if (className != null) {
            this.classNameTextField.setEditable(false);
        } else {
            className = "";
        }
        this.idTextField.setText(id);
        this.classNameTextField.setText(className);
        String displayName = "";
        try {
            displayName = NbBundle.getMessage(AddBeanPanelVisual.class, (String)"TTL_Add_Bean_Panel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.descriptor = new DialogDescriptor((Object)this, displayName, true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddBeanPanelVisual.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    AddBeanPanelVisual.this.collectInput();
                    AddBeanPanelVisual.this.dialogOK = true;
                }
                AddBeanPanelVisual.this.dialog.dispose();
            }
        });
        this.statusLine = this.descriptor.createNotificationLineSupport();
        this.validateInput();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private void collectInput() {
        this.panel.setClassName(this.classNameTextField.getText());
        this.panel.setId(this.idTextField.getText());
    }

    private void validateInput() {
        this.validateInput(true);
    }

    private void validateInput(boolean validateClass) {
        if (this.descriptor == null) {
            return;
        }
        if (this.idTextField.getText().length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_Empty_ID"));
            this.descriptor.setValid(false);
            return;
        }
        if (this.idExist()) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_not_uniq_ID"));
            this.descriptor.setValid(false);
            return;
        }
        if (this.classNameTextField.getText().length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_Empty_Class"));
            this.descriptor.setValid(false);
            return;
        }
        if (this.beanExist()) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_Bean_Already_exist"));
            this.descriptor.setValid(false);
            return;
        }
        if (validateClass) {
            this.scanningLabel.setVisible(SourceUtils.isScanInProgress());
            RP.submit(new Runnable(){

                @Override
                public void run() {
                    AddBeanPanelVisual.this.validClass();
                }
            });
        }
        if (!this.classFound.get()) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_No_Such_class"));
            this.descriptor.setValid(false);
            return;
        }
        this.statusLine.clearMessages();
        this.descriptor.setValid(true);
    }

    private boolean idExist() {
        SpringScope scope = SpringScope.getSpringScope((FileObject)this.fileObject);
        final String id = this.idTextField.getText();
        final boolean[] found = new boolean[]{false};
        for (SpringConfigModel model : scope.getAllConfigModels()) {
            try {
                model.runReadAction((Action)new Action<SpringBeans>(){

                    public void run(SpringBeans beans) {
                        SpringBean bean = beans.findBean(id);
                        if (bean != null) {
                            found[0] = true;
                        }
                    }
                });
                if (!found[0]) continue;
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return found[0];
    }

    private boolean beanExist() {
        final boolean[] found = new boolean[]{false};
        SpringScope scope = SpringScope.getSpringScope((FileObject)this.fileObject);
        final String className = this.classNameTextField.getText();
        if (className == null || "".equals(className)) {
            return false;
        }
        for (SpringConfigModel model : scope.getAllConfigModels()) {
            try {
                model.runReadAction((Action)new Action<SpringBeans>(){

                    public void run(SpringBeans beans) {
                        for (SpringBean bean : beans.getBeans()) {
                            if (!className.equals(bean.getClassName())) continue;
                            found[0] = true;
                            break;
                        }
                    }
                });
                if (!found[0]) continue;
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return found[0];
    }

    private void validClass() {
        JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)this.fileObject), (FileObject[])new FileObject[0]);
        if (js == null) {
            return;
        }
        try {
            ClassSeeker laterSeeker = new ClassSeeker();
            Future seekingTask = js.runWhenScanFinished((Task)laterSeeker, true);
            if (seekingTask.isDone()) {
                this.classFound.set(laterSeeker.isClassFound());
                return;
            }
            ClassSeeker promptSeeker = new ClassSeeker();
            js.runUserActionTask((Task)promptSeeker, true);
            this.classFound.set(promptSeeker.isClassFound());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.idTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.classNameTextField = new JTextField();
        this.scanningLabel = new JLabel();
        this.setPreferredSize(new Dimension(420, 120));
        this.setRequestFocusEnabled(false);
        this.jLabel1.setLabelFor(this.idTextField);
        this.jLabel1.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.jLabel1.text"));
        this.idTextField.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.idTextField.text"));
        this.idTextField.setMinimumSize(new Dimension(200, 27));
        this.idTextField.setPreferredSize(new Dimension(450, 27));
        this.idTextField.setRequestFocusEnabled(false);
        this.jLabel2.setLabelFor(this.classNameTextField);
        this.jLabel2.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.jLabel2.text"));
        this.classNameTextField.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.classNameTextField.text"));
        this.classNameTextField.setPreferredSize(new Dimension(450, 27));
        this.scanningLabel.setFont(new Font("Dialog", 2, 12));
        this.scanningLabel.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.scanningLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scanningLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idTextField, -1, 350, Short.MAX_VALUE).addComponent(this.classNameTextField, -2, 1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.idTextField, -2, 18, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.classNameTextField, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanningLabel).addContainerGap()));
    }

    private class ClassSeeker
    implements Task<CompilationController> {
        private final AtomicBoolean found = new AtomicBoolean(false);

        private ClassSeeker() {
        }

        public boolean isClassFound() {
            return this.found.get();
        }

        public void run(CompilationController parameter) throws Exception {
            this.found.set(parameter.getElements().getTypeElement(AddBeanPanelVisual.this.classNameTextField.getText()) != null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddBeanPanelVisual.this.scanningLabel.setVisible(SourceUtils.isScanInProgress());
                    AddBeanPanelVisual.this.validateInput(false);
                }
            });
        }
    }
}

