/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.readers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.readers.CatalogReader;

public class TextCatalogReader
implements CatalogReader {
    protected InputStream catfile = null;
    protected int[] stack = new int[3];
    protected Stack tokenStack = new Stack();
    protected int top = -1;
    protected boolean caseSensitive = false;

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void readCatalog(Catalog catalog, String string) throws MalformedURLException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file:///" + string);
        }
        URLConnection uRLConnection = uRL.openConnection();
        try {
            this.readCatalog(catalog, uRLConnection.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", uRL.toString());
        }
    }

    @Override
    public void readCatalog(Catalog catalog, InputStream inputStream) throws MalformedURLException, IOException {
        this.catfile = inputStream;
        if (this.catfile == null) {
            return;
        }
        Vector<String> vector = null;
        block4: while (true) {
            try {
                while (true) {
                    String string;
                    if ((string = this.nextToken()) == null) {
                        if (vector != null) {
                            catalog.unknownEntry(vector);
                            vector = null;
                        }
                        this.catfile.close();
                        this.catfile = null;
                        return;
                    }
                    String string2 = null;
                    string2 = this.caseSensitive ? string : string.toUpperCase();
                    try {
                        int n = CatalogEntry.getEntryType(string2);
                        int n2 = CatalogEntry.getEntryArgCount(n);
                        Vector<String> vector2 = new Vector<String>();
                        if (vector != null) {
                            catalog.unknownEntry(vector);
                            vector = null;
                        }
                        for (int i = 0; i < n2; ++i) {
                            vector2.addElement(this.nextToken());
                        }
                        catalog.addEntry(new CatalogEntry(string2, vector2));
                        continue block4;
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.addElement(string);
                            continue;
                        }
                        if (catalogException.getExceptionType() == 2) {
                            catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", string);
                            vector = null;
                            continue;
                        }
                        if (catalogException.getExceptionType() != 8) continue;
                        catalog.getCatalogManager().debug.message(1, catalogException.getMessage());
                        continue;
                    }
                    break;
                }
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 8) {
                    catalog.getCatalogManager().debug.message(1, catalogException.getMessage());
                }
                return;
            }
        }
    }

    protected void finalize() {
        if (this.catfile != null) {
            try {
                this.catfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.catfile = null;
    }

    protected String nextToken() throws IOException, CatalogException {
        int n;
        int n2;
        String string;
        block9: {
            string = "";
            if (!this.tokenStack.empty()) {
                return (String)this.tokenStack.pop();
            }
            do {
                n = this.catfile.read();
                while (n <= 32) {
                    n = this.catfile.read();
                    if (n >= 0) continue;
                    return null;
                }
                n2 = this.catfile.read();
                if (n2 < 0) {
                    return null;
                }
                if (n != 45 || n2 != 45) break block9;
                n = 32;
                n2 = this.nextChar();
                while ((n != 45 || n2 != 45) && n2 > 0) {
                    n = n2;
                    n2 = this.nextChar();
                }
            } while (n2 >= 0);
            throw new CatalogException(8, "Unterminated comment in catalog file; EOF treated as end-of-comment.");
        }
        this.stack[++this.top] = n2;
        this.stack[++this.top] = n;
        n = this.nextChar();
        if (n == 34 || n == 39) {
            int n3 = n;
            while ((n = this.nextChar()) != n3) {
                char[] cArray = new char[]{(char)n};
                String string2 = new String(cArray);
                string = string.concat(string2);
            }
            return string;
        }
        while (n > 32) {
            n2 = this.nextChar();
            if (n == 45 && n2 == 45) {
                this.stack[++this.top] = n;
                this.stack[++this.top] = n2;
                return string;
            }
            char[] cArray = new char[]{(char)n};
            String string3 = new String(cArray);
            string = string.concat(string3);
            n = n2;
        }
        return string;
    }

    protected int nextChar() throws IOException {
        if (this.top < 0) {
            return this.catfile.read();
        }
        return this.stack[this.top--];
    }
}

