/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.customizer;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.j2ee.ui.customizer.ApplyChangesCustomizer;
import org.netbeans.modules.maven.j2ee.ui.customizer.Bundle;
import org.netbeans.modules.maven.j2ee.ui.customizer.CheckBoxUpdater;
import org.netbeans.modules.maven.j2ee.ui.customizer.ComboBoxUpdater;
import org.netbeans.modules.maven.j2ee.ui.util.WarningPanel;
import org.netbeans.modules.maven.j2ee.ui.util.WarningPanelSupport;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.utils.Server;
import org.netbeans.modules.maven.j2ee.utils.ServerUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public abstract class BaseRunCustomizer
extends JPanel
implements ApplyChangesCustomizer,
HelpCtx.Provider {
    private final J2eeModule.Type type;
    protected final Project project;
    protected final ModelHandle2 handle;
    protected CheckBoxUpdater deployOnSaveUpdater;
    protected ComboBoxUpdater<Server> serverUpdater;

    public BaseRunCustomizer(ModelHandle2 handle, Project project, J2eeModule.Type type) {
        this.handle = handle;
        this.project = project;
        this.type = type;
    }

    protected void initDeployOnSave(final JCheckBox dosCheckBox, final JLabel dosDescription) {
        boolean isDoS = MavenProjectSupport.isDeployOnSave(this.project);
        CheckBoxUpdater.Store store = new CheckBoxUpdater.Store(){

            @Override
            public void storeValue(boolean value) {
                MavenProjectSupport.setDeployOnSave(BaseRunCustomizer.this.project, value);
            }
        };
        CheckBoxUpdater.Verify verifier = new CheckBoxUpdater.Verify(){

            @Override
            public boolean verifyValue(boolean value) {
                if (!value && WarningPanelSupport.isAutomaticBuildWarningActivated() && BaseRunCustomizer.this.type == J2eeModule.Type.WAR) {
                    WarningPanel panel = new WarningPanel(Bundle.WARNING_ChangingAutomaticBuild());
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)panel, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (dd.getValue() == NotifyDescriptor.CANCEL_OPTION) {
                        return false;
                    }
                    if (panel.disabledWarning()) {
                        WarningPanelSupport.dontShowAutomaticBuildWarning();
                    }
                }
                return true;
            }
        };
        this.deployOnSaveUpdater = CheckBoxUpdater.create(dosCheckBox, isDoS, store, verifier);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                BaseRunCustomizer.this.updateDoSEnablement(dosCheckBox, dosDescription);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    protected void initServerModel(JComboBox serverCBox, JLabel serverLabel) {
        List<Server> servers = ServerUtils.findServersFor(this.type);
        final Server defaultServer = ServerUtils.findServer(this.project);
        serverCBox.setModel(new DefaultComboBoxModel<Object>(servers.toArray()));
        this.serverUpdater = ComboBoxUpdater.create(serverCBox, serverLabel, defaultServer, new ComboBoxUpdater.Store(){

            @Override
            public void storeValue(Object newServer) {
                if (newServer == null) {
                    JavaEEProjectSettings.setServerInstanceID((Project)BaseRunCustomizer.this.project, (String)defaultServer.getServerInstanceID());
                } else if (newServer instanceof Server) {
                    Server selectedServer = (Server)newServer;
                    String serverID = selectedServer.getServerID();
                    String serverInstanceID = selectedServer.getServerInstanceID();
                    if ("DEV-NULL".equals(serverInstanceID)) {
                        MavenProjectSupport.setServerID(BaseRunCustomizer.this.project, null);
                        JavaEEProjectSettings.setServerInstanceID((Project)BaseRunCustomizer.this.project, null);
                    } else {
                        MavenProjectSupport.setServerID(BaseRunCustomizer.this.project, serverID);
                        JavaEEProjectSettings.setServerInstanceID((Project)BaseRunCustomizer.this.project, (String)serverInstanceID);
                    }
                    MavenProjectSupport.changeServer(BaseRunCustomizer.this.project, false);
                }
            }
        });
    }

    private void updateDoSEnablement(JCheckBox dosCheckBox, JLabel dosDescription) {
        String cos = this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
        boolean enabled = cos == null || "all".equalsIgnoreCase(cos) || "app".equalsIgnoreCase(cos);
        dosCheckBox.setEnabled(enabled);
        dosDescription.setEnabled(enabled);
        if (enabled) {
            dosDescription.setText(Bundle.DosDescription_text());
        } else {
            dosDescription.setText(Bundle.DosDescriptionIfDisabled_text());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("maven_settings");
    }
}

