/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenPopup;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class IsOverriddenAnnotationAction
extends AbstractAction {
    public static final Logger LOG = Logger.getLogger(IsOverriddenAnnotationAction.class.getName());
    private static final Set<String> COMBINED_TYPES = Set.of("org-netbeans-modules-editor-annotations-implements-has-implementations-combined", "org-netbeans-modules-editor-annotations-implements-is-overridden-combined", "org-netbeans-modules-editor-annotations-override-is-overridden-combined");

    public IsOverriddenAnnotationAction() {
        this.putValue("Name", NbBundle.getMessage(IsOverriddenAnnotationAction.class, (String)"CTL_IsOverriddenAnnotationAction"));
        this.putValue("supported-annotation-types", new String[]{"org-netbeans-modules-editor-annotations-is_overridden", "org-netbeans-modules-editor-annotations-has_implementations", "org-netbeans-modules-editor-annotations-implements", "org-netbeans-modules-editor-annotations-overrides"});
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.invokeDefaultAction((JTextComponent)e.getSource())) {
            Action a;
            int nextAction;
            Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)e.getSource());
            if (actions == null) {
                return;
            }
            for (nextAction = 0; nextAction < actions.length && actions[nextAction] != this; ++nextAction) {
            }
            if (actions.length > ++nextAction && (a = actions[nextAction]) != null && a.isEnabled()) {
                a.actionPerformed(e);
            }
        }
    }

    private FileObject getFile(JTextComponent component) {
        Document doc = component.getDocument();
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        return od.getPrimaryFile();
    }

    private IsOverriddenAnnotation findAnnotation(JTextComponent component, AnnotationDesc desc, int offset) {
        FileObject file = this.getFile(component);
        if (file == null) {
            LOG.log(Level.WARNING, "component={0} does not have a file specified in the document.", component);
            return null;
        }
        AnnotationsHolder ah = AnnotationsHolder.get(file);
        if (ah == null) {
            LOG.log(Level.INFO, "component={0} does not have attached a IsOverriddenAnnotationHandler", component);
            return null;
        }
        for (IsOverriddenAnnotation a : ah.getAnnotations()) {
            if (a.getPosition().getOffset() != offset || !desc.getShortDescription().equals(a.getShortDescription())) continue;
            return a;
        }
        return null;
    }

    private List<IsOverriddenAnnotation> findAnnotations(JTextComponent component, int offset) {
        FileObject file = this.getFile(component);
        if (file == null) {
            LOG.log(Level.WARNING, "component={0} does not have a file specified in the document.", component);
            return null;
        }
        AnnotationsHolder ah = AnnotationsHolder.get(file);
        if (ah == null) {
            LOG.log(Level.INFO, "component={0} does not have attached a IsOverriddenAnnotationHandler", component);
            return null;
        }
        LinkedList<IsOverriddenAnnotation> annotations = new LinkedList<IsOverriddenAnnotation>();
        for (IsOverriddenAnnotation a : ah.getAnnotations()) {
            if (a.getPosition().getOffset() != offset) continue;
            annotations.add(a);
        }
        return annotations;
    }

    boolean invokeDefaultAction(JTextComponent comp) {
        Document doc = comp.getDocument();
        if (doc instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)doc;
            int currentPosition = comp.getCaretPosition();
            Annotations annotations = baseDocument.getAnnotations();
            LinkedHashMap<String, List<ElementDescription>> caption2Descriptions = new LinkedHashMap<String, List<ElementDescription>>();
            Point[] p = new Point[1];
            doc.render(() -> {
                try {
                    int line = LineDocumentUtils.getLineIndex((LineDocument)baseDocument, (int)currentPosition);
                    int startOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)baseDocument, (int)line);
                    p[0] = comp.modelToView(startOffset).getLocation();
                    AnnotationDesc desc = annotations.getActiveAnnotation(line);
                    if (desc == null) {
                        return;
                    }
                    List<IsOverriddenAnnotation> annots = COMBINED_TYPES.contains(desc.getAnnotationType()) ? this.findAnnotations(comp, startOffset) : List.of(this.findAnnotation(comp, desc, startOffset));
                    for (IsOverriddenAnnotation a : annots) {
                        if (a == null) continue;
                        caption2Descriptions.put(IsOverriddenAnnotationAction.computeCaption(a.getType(), a.getShortDescription()), a.getDeclarations());
                    }
                }
                catch (BadLocationException ex) {
                    LOG.log(Level.WARNING, "bad location", ex);
                }
            });
            if (caption2Descriptions.isEmpty()) {
                return false;
            }
            JumpList.addEntry((JTextComponent)comp, (int)currentPosition);
            IsOverriddenAnnotationAction.mouseClicked(caption2Descriptions, comp, p[0]);
            return true;
        }
        return false;
    }

    static void mouseClicked(Map<String, List<ElementDescription>> caption2Descriptions, JTextComponent c, Point p) {
        if (caption2Descriptions.size() == 1 && caption2Descriptions.values().iterator().next().size() == 1) {
            ElementDescription desc = caption2Descriptions.values().iterator().next().get(0);
            desc.open();
            return;
        }
        Point position = new Point(p);
        SwingUtilities.convertPointToScreen(position, c);
        StringBuilder caption = new StringBuilder();
        LinkedList<ElementDescription> descriptions = new LinkedList<ElementDescription>();
        boolean first = true;
        for (Map.Entry<String, List<ElementDescription>> e : caption2Descriptions.entrySet()) {
            if (!first) {
                caption.append("/");
            }
            first = false;
            caption.append(e.getKey());
            descriptions.addAll((Collection<ElementDescription>)e.getValue());
        }
        PopupUtil.showPopup(new IsOverriddenPopup(caption.toString(), descriptions), caption.toString(), position.x, position.y, true, 0);
    }

    static String computeCaption(AnnotationType type, String shortDescription) throws MissingResourceException, IllegalStateException {
        return switch (type) {
            case AnnotationType.IMPLEMENTS -> NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Implements");
            case AnnotationType.OVERRIDES -> NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Overrides");
            case AnnotationType.HAS_IMPLEMENTATION, AnnotationType.IS_OVERRIDDEN -> shortDescription;
            default -> throw new IllegalStateException("Currently not implemented: " + type);
        };
    }
}

