/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.csl.CssPropertyElement;
import org.netbeans.modules.css.editor.module.PropertiesReader;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.lib.api.CssModule;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.PropertyCategory;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class Utilities {
    public static final String CATEGORY_META_PROPERTY_NAME = "$category";

    private Utilities() {
    }

    public static <T extends Set<OffsetRange>> NodeVisitor<T> createMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result, NodeType ... nodeTypesToMatch) {
        final Snapshot snapshot = context.getSnapshot();
        int astCaretOffset = snapshot.getEmbeddedOffset(context.getCaretOffset());
        if (astCaretOffset == -1) {
            return null;
        }
        final Node current = NodeUtil.findNonTokenNodeAtOffset((Node)context.getParseTreeRoot(), (int)astCaretOffset);
        if (current == null) {
            return null;
        }
        EnumSet<NodeType> types = EnumSet.copyOf(Arrays.asList(nodeTypesToMatch));
        if (!types.contains(current.type())) {
            return null;
        }
        final CharSequence selectedNamespacePrefixImage = current.image();
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                if (node.type() == current.type() && CharSequenceUtilities.textEquals((CharSequence)selectedNamespacePrefixImage, (CharSequence)node.image())) {
                    OffsetRange documentNodeRange = Css3Utils.getDocumentOffsetRange(node, snapshot);
                    ((Set)this.getResult()).add(Css3Utils.getValidOrNONEOffsetRange(documentNodeRange));
                }
                return false;
            }
        };
    }

    public static List<CompletionProposal> createRAWCompletionProposals(Collection<String> props, ElementKind kind, int anchor) {
        return Utilities.createRAWCompletionProposals(props, kind, anchor, null);
    }

    public static List<CompletionProposal> createRAWCompletionProposals(Collection<String> props, ElementKind kind, int anchor, String addPrefix) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        for (String value : props) {
            if (addPrefix != null) {
                value = addPrefix + value;
            }
            CssElement handle = new CssElement(value);
            CssCompletionItem proposal = CssCompletionItem.createRAWCompletionItem(handle, value, kind, anchor, false);
            proposals.add((CompletionProposal)proposal);
        }
        return proposals;
    }

    public static List<CompletionProposal> wrapProperties(Collection<PropertyDefinition> props, int anchor) {
        return Utilities.wrapProperties(props, anchor, 0);
    }

    public static List<CompletionProposal> wrapProperties(Collection<PropertyDefinition> props, int anchor, int stripLen) {
        HashSet<String> names = new HashSet<String>();
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        for (PropertyDefinition p : props) {
            String propName = p.getName();
            if (GrammarElement.isArtificialElementName((CharSequence)propName) || !names.add(propName)) continue;
            CssPropertyElement handle = new CssPropertyElement(p);
            String insertPrefix = stripLen == 0 ? propName : propName.substring(stripLen);
            CssCompletionItem proposal = CssCompletionItem.createPropertyCompletionItem(handle, p, insertPrefix, anchor, false);
            proposals.add((CompletionProposal)proposal);
        }
        return proposals;
    }

    public static Map<String, PropertyDefinition> parsePropertyDefinitionFile(String sourcePath, CssModule module) {
        HashMap<String, PropertyDefinition> properties = new HashMap<String, PropertyDefinition>();
        Collection<Pair<String, String>> parseBundle = PropertiesReader.parseBundle(sourcePath);
        PropertyCategory category = PropertyCategory.DEFAULT;
        for (Pair<String, String> pair : parseBundle) {
            String name = (String)pair.first();
            String value = (String)pair.second();
            if (name.startsWith("$")) {
                if (CATEGORY_META_PROPERTY_NAME.equalsIgnoreCase(name)) {
                    try {
                        category = PropertyCategory.valueOf((String)value.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getAnonymousLogger().log(Level.INFO, String.format("Unknown property category name %s in %s properties definition file. Served by %s css module.", value, sourcePath, module.getSpecificationURL()), e);
                    }
                    continue;
                }
                Logger.getAnonymousLogger().log(Level.INFO, null, new IllegalArgumentException(String.format("Unknown meta property %s in %s properties definition file. Served by %s css module.", name, sourcePath, module.getSpecificationURL())));
                continue;
            }
            StringTokenizer nameTokenizer = new StringTokenizer(name, ";");
            while (nameTokenizer.hasMoreTokens()) {
                String parsed_name = nameTokenizer.nextToken().trim();
                PropertyDefinition prop = new PropertyDefinition(parsed_name, value, category, module);
                properties.put(parsed_name, prop);
            }
        }
        return properties;
    }

    public static boolean isVendorSpecificPropertyValueToken(FileObject file, CharSequence value) {
        return Css3Utils.isVendorSpecificPropertyValue(file, value);
    }

    public static List<CompletionProposal> filterCompletionProposals(List<CompletionProposal> proposals, CharSequence prefix, boolean ignoreCase) {
        ArrayList<CompletionProposal> filtered = new ArrayList<CompletionProposal>();
        for (CompletionProposal proposal : proposals) {
            if (!LexerUtils.startsWith((CharSequence)proposal.getInsertPrefix(), (CharSequence)prefix, (boolean)ignoreCase, (boolean)false)) continue;
            filtered.add(proposal);
        }
        return filtered;
    }
}

