/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.java.project.ui.ExtensionAndImplementationWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtensionAndImplementationVisualPanel
extends JPanel
implements DocumentListener {
    private static final String SUPERCLASS = "superclass";
    private static final String INTERFACES = "interfaces";
    private static final String NEW_LINE = "\n";
    private static final String EMPTY_STRING = "";
    private static final String EXCEPTION_TEMPLATE_NAME = "Exception";
    private static final String INTERFACE_TEMPLATE_NAME = "Interface";
    private final ExtensionAndImplementationWizardPanel wizardPanel;
    private JTextField superclassTextField;
    private JTextArea interfacesTextArea;

    private ExtensionAndImplementationVisualPanel(ExtensionAndImplementationWizardPanel wizardPanel) {
        this.initComponents();
        this.wizardPanel = wizardPanel;
    }

    public static ExtensionAndImplementationVisualPanelBuilder builder(ExtensionAndImplementationWizardPanel wizardPanel) {
        return new ExtensionAndImplementationVisualPanelBuilder(wizardPanel);
    }

    private void setSuperclassTextField(JTextField superclassTextField) {
        this.superclassTextField = superclassTextField;
    }

    private void setInterfacesTextArea(JTextArea interfacesTextArea) {
        this.interfacesTextArea = interfacesTextArea;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
    }

    boolean isValid(WizardDescriptor wizardDescriptor) {
        String interfaces;
        String superclass;
        if (wizardDescriptor == null) {
            return false;
        }
        if (this.superclassTextField != null && !(superclass = this.superclassTextField.getText()).isEmpty() && !this.isValidSuperclassString(superclass)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"INFO_JavaTargetChooser_ProvideValidSuperclass"));
            return false;
        }
        if (this.interfacesTextArea != null && !(interfaces = this.interfacesTextArea.getText()).isEmpty() && !this.isValidInterfacesString(interfaces)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"INFO_JavaTargetChooser_ProvideValidInterfaces"));
            return false;
        }
        return true;
    }

    private boolean isValidSuperclassString(String superclass) {
        if (!(superclass.isEmpty() || superclass.charAt(0) != '.' && superclass.charAt(superclass.length() - 1) != '.')) {
            return false;
        }
        return this.hasValidTokens(superclass);
    }

    private boolean hasValidTokens(String fqn) {
        StringTokenizer tokenizer = new StringTokenizer(fqn, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.isEmpty()) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidInterfacesString(String interfaces) {
        if (!(interfaces.isEmpty() || interfaces.charAt(0) != '.' && interfaces.charAt(interfaces.length() - 1) != '.')) {
            return false;
        }
        if (this.interfacesTextArea != null) {
            for (int i = 0; i < this.interfacesTextArea.getLineCount(); ++i) {
                try {
                    String implementationClass;
                    int lineStartOffset = this.interfacesTextArea.getLineStartOffset(i);
                    int lineEndOffset = this.interfacesTextArea.getLineEndOffset(i);
                    if (lineEndOffset <= lineStartOffset || this.hasValidTokens(implementationClass = this.interfacesTextArea.getText(lineStartOffset, lineEndOffset - lineStartOffset - 1))) continue;
                    return false;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return false;
                }
            }
        }
        return true;
    }

    void readSettings(WizardDescriptor wizardDescriptor) {
        Object interfacesProperty;
        String interfaces;
        String superclass;
        Object superclassProperty = wizardDescriptor.getProperty(SUPERCLASS);
        String string = superclass = superclassProperty != null ? (String)superclassProperty : EMPTY_STRING;
        if (!superclass.isEmpty() && this.superclassTextField != null) {
            this.superclassTextField.setText(superclass);
        }
        String string2 = interfaces = (interfacesProperty = wizardDescriptor.getProperty(INTERFACES)) != null ? (String)interfacesProperty : EMPTY_STRING;
        if (!interfaces.isEmpty() && this.interfacesTextArea != null) {
            this.interfacesTextArea.setText(interfaces);
        }
    }

    void storeSettings(WizardDescriptor wizardDescriptor) {
        if (this.superclassTextField != null) {
            wizardDescriptor.putProperty(SUPERCLASS, (Object)this.superclassTextField.getText());
        }
        if (this.interfacesTextArea != null) {
            wizardDescriptor.putProperty(INTERFACES, (Object)this.interfacesTextArea.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.wizardPanel.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.wizardPanel.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.wizardPanel.fireChangeEvent();
    }

    private void browseSuperclassButtonActionPerformed(ActionEvent evt) {
        ElementHandle handle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                WizardDescriptor wizardDescriptor = ExtensionAndImplementationVisualPanel.this.wizardPanel.getWizardDescriptor();
                FileObject template = Templates.getTemplate((WizardDescriptor)wizardDescriptor);
                if (template != null) {
                    String templateName;
                    switch (templateName = template.getName()) {
                        case "Exception": {
                            return ExtensionAndImplementationVisualPanel.this.isNotFinalExceptionType((ElementHandle<TypeElement>)typeHandle);
                        }
                        case "Interface": {
                            return ExtensionAndImplementationVisualPanel.this.isInterface((ElementHandle<TypeElement>)typeHandle);
                        }
                    }
                    return ExtensionAndImplementationVisualPanel.this.isNotFinalClass((ElementHandle<TypeElement>)typeHandle);
                }
                return false;
            }
        });
        if (handle != null) {
            this.superclassTextField.setText(handle.getQualifiedName());
        }
    }

    private boolean isNotFinalExceptionType(ElementHandle<TypeElement> typeHandle) {
        try {
            Class<?> clazz = Class.forName(typeHandle.getQualifiedName());
            return typeHandle.getKind() == ElementKind.CLASS && Exception.class.isAssignableFrom(clazz) && !Modifier.isFinal(clazz.getModifiers());
        }
        catch (ClassNotFoundException ex) {
            return true;
        }
    }

    private boolean isInterface(ElementHandle<TypeElement> typeHandle) {
        return typeHandle.getKind() == ElementKind.INTERFACE;
    }

    private boolean isNotFinalClass(ElementHandle<TypeElement> typeHandle) {
        try {
            Class<?> clazz = Class.forName(typeHandle.getQualifiedName());
            return typeHandle.getKind() == ElementKind.CLASS && !Modifier.isFinal(clazz.getModifiers());
        }
        catch (ClassNotFoundException ex) {
            return true;
        }
    }

    private void browseInterfacesButtonActionPerformed(ActionEvent evt) {
        ElementHandle handle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                return ExtensionAndImplementationVisualPanel.this.isInterface((ElementHandle<TypeElement>)typeHandle);
            }
        });
        if (handle != null && this.interfacesTextArea != null) {
            String fqn = handle.getQualifiedName();
            if (this.interfacesTextArea.getText().isEmpty()) {
                this.interfacesTextArea.setText(fqn);
            } else {
                String interfaces = this.interfacesTextArea.getText();
                if (!interfaces.contains(fqn)) {
                    this.interfacesTextArea.append(NEW_LINE + fqn);
                }
            }
        }
    }

    public static class ExtensionAndImplementationVisualPanelBuilder {
        private static final int SMALL_VERTICAL_SPACING = 8;
        private static final int SMALL_HORIZONTAL_SPACING = 8;
        private static final int MINIMUM_COMPONENT_HEIGHT = 25;
        private static final int MINIMUM_COMPONENT_WIDTH = 0;
        private static final int DEFAULT_ROW_COUNT = 5;
        private static final int DEFAULT_COLUMN_COUNT = 20;
        private static final int MINIMUM_LABEL_WIDTH = 85;
        private static final int MINIMUM_TEXT_AREA_HEIGHT = 100;
        private final ExtensionAndImplementationWizardPanel wizardPanel;
        private final ExtensionAndImplementationVisualPanel visualPanel;
        private JTextArea interfacesTextArea;
        private JTextField superclassTextField;

        public ExtensionAndImplementationVisualPanelBuilder(ExtensionAndImplementationWizardPanel wizardPanel) {
            this.wizardPanel = wizardPanel;
            this.visualPanel = new ExtensionAndImplementationVisualPanel(wizardPanel);
        }

        public ExtensionAndImplementationVisualPanelBuilder withExtensionBox() {
            Box extensionBox = new Box(0);
            JLabel superclassLabel = new JLabel();
            FileObject template = Templates.getTemplate((WizardDescriptor)this.wizardPanel.getWizardDescriptor());
            if (template != null) {
                String templateName = template.getName();
                if (templateName.equals(ExtensionAndImplementationVisualPanel.INTERFACE_TEMPLATE_NAME)) {
                    Mnemonics.setLocalizedText((JLabel)superclassLabel, (String)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"ExtensionAndImplementationVisualPanel.superinterfaceLabel.text"));
                } else {
                    Mnemonics.setLocalizedText((JLabel)superclassLabel, (String)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"ExtensionAndImplementationVisualPanel.superclassLabel.text"));
                }
            }
            superclassLabel.setAlignmentX(0.0f);
            superclassLabel.setAlignmentY(0.5f);
            superclassLabel.setMinimumSize(new Dimension(85, 25));
            superclassLabel.setPreferredSize(new Dimension(85, 25));
            this.superclassTextField = new JTextField();
            this.superclassTextField.setEditable(false);
            this.superclassTextField.setMinimumSize(new Dimension(0, 25));
            this.superclassTextField.setAlignmentX(0.0f);
            this.superclassTextField.setAlignmentY(0.5f);
            this.superclassTextField.getDocument().addDocumentListener(this.visualPanel);
            superclassLabel.setLabelFor(this.superclassTextField);
            JButton browseSuperclassButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)browseSuperclassButton, (String)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"ExtensionAndImplementationVisualPanel.browseSuperclassButton.text"));
            browseSuperclassButton.addActionListener(x$0 -> this.visualPanel.browseSuperclassButtonActionPerformed(x$0));
            browseSuperclassButton.setAlignmentX(0.0f);
            browseSuperclassButton.setAlignmentY(0.5f);
            extensionBox.add(superclassLabel);
            extensionBox.add(this.superclassTextField);
            extensionBox.add(Box.createHorizontalStrut(8));
            extensionBox.add(browseSuperclassButton);
            extensionBox.add(Box.createHorizontalStrut(8));
            this.visualPanel.add(extensionBox);
            this.visualPanel.add(Box.createVerticalStrut(8));
            return this;
        }

        public ExtensionAndImplementationVisualPanelBuilder withImplementationBox() {
            Box implementationBox = new Box(0);
            JLabel interfacesLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)interfacesLabel, (String)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"ExtensionAndImplementationVisualPanel.interfacesLabel.text"));
            interfacesLabel.setAlignmentX(0.0f);
            interfacesLabel.setAlignmentY(0.0f);
            interfacesLabel.setMinimumSize(new Dimension(85, 25));
            interfacesLabel.setPreferredSize(new Dimension(85, 25));
            JScrollPane interfacesScrollPane = new JScrollPane();
            this.interfacesTextArea = new JTextArea();
            this.interfacesTextArea.setEditable(false);
            this.interfacesTextArea.setColumns(20);
            this.interfacesTextArea.setRows(5);
            this.interfacesTextArea.getDocument().addDocumentListener(this.visualPanel);
            interfacesLabel.setLabelFor(this.interfacesTextArea);
            interfacesScrollPane.setViewportView(this.interfacesTextArea);
            interfacesScrollPane.setAlignmentX(0.0f);
            interfacesScrollPane.setAlignmentY(0.0f);
            interfacesScrollPane.setMinimumSize(new Dimension(0, 100));
            JButton browseInterfacesButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)browseInterfacesButton, (String)NbBundle.getMessage(ExtensionAndImplementationVisualPanel.class, (String)"ExtensionAndImplementationVisualPanel.browseInterfacesButton.text"));
            browseInterfacesButton.addActionListener(x$0 -> this.visualPanel.browseInterfacesButtonActionPerformed(x$0));
            browseInterfacesButton.setAlignmentX(0.0f);
            browseInterfacesButton.setAlignmentY(0.0f);
            implementationBox.add(interfacesLabel);
            implementationBox.add(interfacesScrollPane);
            implementationBox.add(Box.createHorizontalStrut(8));
            implementationBox.add(browseInterfacesButton);
            implementationBox.add(Box.createHorizontalStrut(8));
            this.visualPanel.add(implementationBox);
            return this;
        }

        public ExtensionAndImplementationVisualPanel build() {
            this.visualPanel.setSuperclassTextField(this.superclassTextField);
            this.visualPanel.setInterfacesTextArea(this.interfacesTextArea);
            this.visualPanel.add(Box.createRigidArea(new Dimension(0, Integer.MAX_VALUE)));
            return this.visualPanel;
        }
    }
}

