/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.execution;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer2;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.spi.support.NativeExecutionUserNotification;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.terminal.api.IOEmulation;
import org.netbeans.modules.terminal.api.IOTerm;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NativeExecutionService {
    private final NativeProcessBuilder processBuilder;
    private final String displayName;
    private final NativeExecutionDescriptor descriptor;
    private static final Charset execCharset;
    private Runnable postExecutable;
    private final AtomicReference<NativeProcess> processRef = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ProcessChangeListener listener;
    private long startTimeMillis;

    private NativeExecutionService(NativeProcessBuilder processBuilder, String displayName, NativeExecutionDescriptor descriptor) {
        this.processBuilder = processBuilder;
        this.displayName = displayName;
        this.descriptor = descriptor;
    }

    public static NativeExecutionService newService(NativeProcessBuilder processBuilder, NativeExecutionDescriptor descriptor, String displayName) {
        return new NativeExecutionService(processBuilder, displayName, descriptor);
    }

    public Future<Integer> run() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("NativeExecutionService state error - cannot be called more than once!");
        }
        this.listener = new ProcessChangeListener();
        this.processBuilder.addNativeProcessListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this.listener, (Object)this.processBuilder));
        this.postExecutable = this.descriptor.postExecution;
        this.descriptor.postExecution(new PostRunnable());
        if (IOTerm.isSupported((InputOutput)this.descriptor.inputOutput)) {
            return this.runTerm();
        }
        return this.runRegular();
    }

    private Future<Integer> runTerm() {
        final AtomicReference<Object> runTaskRef = new AtomicReference<Object>(null);
        this.processBuilder.setUsePty(true);
        if (IOEmulation.isSupported((InputOutput)this.descriptor.inputOutput)) {
            String termType = this.processBuilder.getEnvironment().get("TERM");
            if (termType != null && termType.startsWith("xterm")) {
                this.processBuilder.getEnvironment().put("TERM", termType);
            } else {
                this.processBuilder.getEnvironment().put("TERM", "xterm");
            }
        } else {
            this.processBuilder.getEnvironment().put("TERM", "dumb");
        }
        this.processBuilder.setCharset(this.descriptor.charset);
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                Integer n;
                block37: {
                    NativeProcess process;
                    ProgressHandle progressHandle;
                    block33: {
                        Integer n2;
                        block34: {
                            progressHandle = null;
                            try {
                                if (((NativeExecutionService)NativeExecutionService.this).descriptor.showProgress) {
                                    Cancellable c = null;
                                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.controllable) {
                                        c = new Cancellable(){

                                            public boolean cancel() {
                                                FutureTask task = (FutureTask)runTaskRef.get();
                                                if (task != null) {
                                                    return task.cancel(true);
                                                }
                                                return false;
                                            }
                                        };
                                    }
                                    progressHandle = ProgressHandle.createHandle((String)NativeExecutionService.this.displayName, (Cancellable)c);
                                    progressHandle.start();
                                }
                                process = NativeExecutionService.this.processBuilder.call();
                                IOTerm.setReadOnly((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (!((NativeExecutionService)NativeExecutionService.this).descriptor.inputVisible ? 1 : 0) != 0);
                                PtySupport.connect(((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, process, new PreExecution());
                                if (process.getState() != NativeProcess.State.ERROR) break block33;
                                NativeExecutionService.this.out(true, new CharSequence[]{ProcessUtils.readProcessErrorLine(process), "\r"});
                                n2 = 1;
                                if (progressHandle == null) break block34;
                            }
                            catch (Throwable throwable) {
                                if (progressHandle != null) {
                                    progressHandle.finish();
                                }
                                CountDownLatch latch = new CountDownLatch(1);
                                IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (Runnable)new Runnable(){
                                    final /* synthetic */ CountDownLatch val$latch;
                                    {
                                        this.val$latch = countDownLatch;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$latch.countDown();
                                    }
                                });
                                try {
                                    latch.await(5L, TimeUnit.SECONDS);
                                }
                                finally {
                                    try {
                                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                                            ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                                        }
                                    }
                                    finally {
                                        IOTerm.setReadOnly((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (boolean)true);
                                    }
                                }
                                throw throwable;
                            }
                            progressHandle.finish();
                        }
                        CountDownLatch latch = new CountDownLatch(1);
                        IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (Runnable)new /* invalid duplicate definition of identical inner class */);
                        try {
                            latch.await(5L, TimeUnit.SECONDS);
                        }
                        finally {
                            try {
                                if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                                    ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                                }
                            }
                            finally {
                                IOTerm.setReadOnly((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (boolean)true);
                            }
                        }
                        return n2;
                    }
                    n = process.waitFor();
                    if (progressHandle == null) break block37;
                    progressHandle.finish();
                }
                CountDownLatch latch = new CountDownLatch(1);
                IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (Runnable)new /* invalid duplicate definition of identical inner class */);
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                finally {
                    try {
                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                            ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                        }
                    }
                    finally {
                        IOTerm.setReadOnly((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (boolean)true);
                    }
                }
                return n;
            }
        };
        FutureTask<Integer> runTask = new FutureTask<Integer>((Callable)callable){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                AtomicReference atomicReference = NativeExecutionService.this.processRef;
                synchronized (atomicReference) {
                    NativeProcess process = (NativeProcess)NativeExecutionService.this.processRef.get();
                    if (process != null) {
                        process.destroy();
                    }
                    return true;
                }
            }
        };
        runTaskRef.set(runTask);
        NativeTaskExecutorService.submit(runTask, "start process in term");
        return runTask;
    }

    private Future<Integer> runRegular() {
        Charset charset = this.descriptor.charset;
        if (charset == null) {
            charset = execCharset;
        }
        Logger.getInstance().log(Level.FINE, "Input stream charset: {0}", charset);
        ExecutionDescriptor descr = new ExecutionDescriptor().controllable(this.descriptor.controllable).frontWindow(this.descriptor.frontWindow).preExecution((Runnable)new PreExecution()).inputVisible(this.descriptor.inputVisible).inputOutput(this.descriptor.inputOutput).outLineBased(this.descriptor.outLineBased).showProgress(this.descriptor.showProgress).postExecution(this.descriptor.postExecution).noReset(!this.descriptor.resetInputOutputOnFinish).errConvertorFactory(this.descriptor.errConvertorFactory).outConvertorFactory(this.descriptor.outConvertorFactory).charset(charset);
        return ExecutionService.newService((Callable)this.processBuilder, (ExecutionDescriptor)descr, (String)this.displayName).run();
    }

    private static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    private void out(final boolean toError, final CharSequence ... cs) {
        Mutex.Action<Void> action = new Mutex.Action<Void>(){

            public Void run() {
                if (((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput != null) {
                    OutputWriter w;
                    OutputWriter outputWriter = w = toError ? ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr() : ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut();
                    if (w != null) {
                        for (CharSequence c : cs) {
                            w.append(c);
                        }
                    }
                }
                return null;
            }
        };
        if (NativeExecutionService.isUnitTestMode()) {
            action.run();
        } else {
            Mutex.EVENT.writeAccess((Mutex.Action)action);
        }
    }

    private void closeIO() {
        Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                OutputWriter err;
                OutputWriter out = ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput == null ? null : ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut();
                OutputWriter outputWriter = err = ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput == null ? null : ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr();
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    static {
        String charsetName = System.getProperty("org.netbeans.modules.nativeexecution.execcharset", "UTF-8");
        Charset cs = null;
        try {
            cs = Charset.forName(charsetName);
        }
        catch (Exception ex) {
            cs = Charset.defaultCharset();
        }
        finally {
            execCharset = cs;
        }
    }

    private final class ProcessChangeListener
    implements ChangeListener {
        private ProcessChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            NativeExecutionService.this.processRef.compareAndSet(null, (NativeProcess)event.getSource());
            switch (event.state) {
                case RUNNING: 
                case ERROR: {
                    NativeExecutionService.this.startTimeMillis = System.currentTimeMillis();
                }
            }
        }
    }

    private final class PostRunnable
    implements Runnable {
        private PostRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            NativeProcess process = (NativeProcess)NativeExecutionService.this.processRef.get();
            if (process == null) {
                return;
            }
            int rc = -1;
            try {
                rc = process.waitFor();
                Logger.getInstance().fine("NativeExecutionService FINISHING");
            }
            catch (InterruptedException time22) {
                Logger.getInstance().fine("NativeExecutionService FINISHING");
                long time = System.currentTimeMillis() - NativeExecutionService.this.startTimeMillis;
                if (IOColorLines.isSupported((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput) && ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer instanceof PostMessageDisplayer2) {
                    PostMessageDisplayer2 pmd = (PostMessageDisplayer2)((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer;
                    pmd.outPostMessage(((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, process, time);
                    NativeExecutionUserNotification.getDefault().notifyStatus(pmd.getPostStatusString(process));
                    Logger.getInstance().fine("NativeExecutionService FINISHING have sent colored notification");
                } else if (((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer != null) {
                    String postMsg = ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostMessage(process, time);
                    NativeExecutionService.this.out(rc != 0, new CharSequence[]{"\n\r", postMsg, "\n\r"});
                    if (!NativeExecutionService.isUnitTestMode()) {
                        NativeExecutionUserNotification.getDefault().notifyStatus(((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostStatusString(process));
                    }
                    Logger.getInstance().log(Level.FINE, "NativeExecutionService FINISHING have sent notification {0}", postMsg);
                }
                try {
                    if (NativeExecutionService.this.postExecutable == null) return;
                    Logger.getInstance().fine("NativeExecutionService FINISHING start post executable");
                    NativeExecutionService.this.postExecutable.run();
                    Logger.getInstance().fine("NativeExecutionService FINISHING have been executed post executable");
                    return;
                }
                finally {
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.closeInputOutputOnFinish) {
                        NativeExecutionService.this.closeIO();
                    }
                    Logger.getInstance().fine("NativeExecutionService FINISHED");
                }
            }
            catch (Throwable throwable) {
                Logger.getInstance().fine("NativeExecutionService FINISHING");
                long time = System.currentTimeMillis() - NativeExecutionService.this.startTimeMillis;
                if (IOColorLines.isSupported((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput) && ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer instanceof PostMessageDisplayer2) {
                    PostMessageDisplayer2 pmd = (PostMessageDisplayer2)((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer;
                    pmd.outPostMessage(((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, process, time);
                    NativeExecutionUserNotification.getDefault().notifyStatus(pmd.getPostStatusString(process));
                    Logger.getInstance().fine("NativeExecutionService FINISHING have sent colored notification");
                } else if (((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer != null) {
                    String postMsg = ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostMessage(process, time);
                    NativeExecutionService.this.out(rc != 0, new CharSequence[]{"\n\r", postMsg, "\n\r"});
                    if (!NativeExecutionService.isUnitTestMode()) {
                        NativeExecutionUserNotification.getDefault().notifyStatus(((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostStatusString(process));
                    }
                    Logger.getInstance().log(Level.FINE, "NativeExecutionService FINISHING have sent notification {0}", postMsg);
                }
                try {
                    if (NativeExecutionService.this.postExecutable == null) throw throwable;
                    Logger.getInstance().fine("NativeExecutionService FINISHING start post executable");
                    NativeExecutionService.this.postExecutable.run();
                    Logger.getInstance().fine("NativeExecutionService FINISHING have been executed post executable");
                    throw throwable;
                }
                finally {
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.closeInputOutputOnFinish) {
                        NativeExecutionService.this.closeIO();
                    }
                    Logger.getInstance().fine("NativeExecutionService FINISHED");
                }
            }
            long time22 = System.currentTimeMillis() - NativeExecutionService.this.startTimeMillis;
            if (IOColorLines.isSupported((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput) && ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer instanceof PostMessageDisplayer2) {
                PostMessageDisplayer2 pmd = (PostMessageDisplayer2)((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer;
                pmd.outPostMessage(((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, process, time22);
                NativeExecutionUserNotification.getDefault().notifyStatus(pmd.getPostStatusString(process));
                Logger.getInstance().fine("NativeExecutionService FINISHING have sent colored notification");
            } else if (((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer != null) {
                String postMsg = ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostMessage(process, time22);
                NativeExecutionService.this.out(rc != 0, new CharSequence[]{"\n\r", postMsg, "\n\r"});
                if (!NativeExecutionService.isUnitTestMode()) {
                    NativeExecutionUserNotification.getDefault().notifyStatus(((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostStatusString(process));
                }
                Logger.getInstance().log(Level.FINE, "NativeExecutionService FINISHING have sent notification {0}", postMsg);
            }
            try {
                if (NativeExecutionService.this.postExecutable == null) return;
                Logger.getInstance().fine("NativeExecutionService FINISHING start post executable");
                NativeExecutionService.this.postExecutable.run();
                Logger.getInstance().fine("NativeExecutionService FINISHING have been executed post executable");
                return;
            }
            finally {
                if (((NativeExecutionService)NativeExecutionService.this).descriptor.closeInputOutputOnFinish) {
                    NativeExecutionService.this.closeIO();
                }
                Logger.getInstance().fine("NativeExecutionService FINISHED");
            }
        }
    }

    private class PreExecution
    implements Runnable {
        private PreExecution() {
        }

        @Override
        public void run() {
            if (((NativeExecutionService)NativeExecutionService.this).descriptor.frontWindow) {
                if (IOSelect.isSupported((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput)) {
                    IOSelect.select((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, EnumSet.of(IOSelect.AdditionalOperation.OPEN, IOSelect.AdditionalOperation.REQUEST_VISIBLE));
                } else if (((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput != null) {
                    ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.select();
                }
            }
            if (((NativeExecutionService)NativeExecutionService.this).descriptor.requestFocus) {
                IOTerm.requestFocus((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput);
            }
        }
    }
}

