/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum Scope implements Api
{
    PUBLIC("Public", "public"),
    DIRECTLY_DOWNLOADABLE("Directly downloadable", "directly_downloadable"),
    NOT_DIRECTLY_DOWNLOADABLE("Not directly downloadable", "not_directly_downloadable"),
    BUILD_OF_OPEN_JDK("Build of OpenJDK", "build_of_openjdk"),
    BUILD_OF_GRAALVM("Build of GraalVM", "build_of_graalvm"),
    FREE_TO_USE_IN_PRODUCTION("Free to use in production", "free_to_use_in_production"),
    LICENSE_NEEDED_FOR_PRODUCTION("License needed for production", "license_needed_for_production"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private Scope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Scope getDefault() {
        return NONE;
    }

    @Override
    public Scope getNotFound() {
        return NOT_FOUND;
    }

    public Scope[] getAll() {
        return Scope.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static Scope fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "public": 
            case "PUBLIC": {
                return PUBLIC;
            }
            case "directly_downloadable": 
            case "DIRECTLY_DOWNLOADABLE": 
            case "direct_download": 
            case "DIRECT_DOWNLOAD": {
                return DIRECTLY_DOWNLOADABLE;
            }
            case "not_directly_downloadable": 
            case "NOT_DIRECTLY_DOWNLOADABLE": 
            case "no_direct_download": 
            case "NO_DIRECT_DOWNLOAD": {
                return NOT_DIRECTLY_DOWNLOADABLE;
            }
            case "build_of_open_jdk": 
            case "BUILD_OF_OPEN_JDK": 
            case "build_of_openjdk": 
            case "BUILD_OF_OPENJDK": {
                return BUILD_OF_OPEN_JDK;
            }
            case "build_of_graalvm": 
            case "BUILD_OF_GRAALVM": {
                return BUILD_OF_GRAALVM;
            }
            case "free": 
            case "free_to_use": 
            case "free_to_use_in_production": {
                return FREE_TO_USE_IN_PRODUCTION;
            }
            case "license": 
            case "license_needed": 
            case "license_needed_for_production": {
                return LICENSE_NEEDED_FOR_PRODUCTION;
            }
        }
        return NOT_FOUND;
    }

    public static List<Scope> getAsList() {
        return Arrays.asList(Scope.values());
    }
}

