/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.ViewScopeContextManager;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.util.LRUMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructViewMapEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.ViewMapListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class ViewScopeManager
implements HttpSessionListener,
ViewMapListener {
    private static final Logger LOGGER = Logger.getLogger(ViewScopeManager.class.getName());
    public static final String ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    public static final String ACTIVE_VIEW_MAPS_SIZE = "com.sun.faces.application.view.activeViewMapsSize";
    public static final String VIEW_MAP = "com.sun.faces.application.view.viewMap";
    public static final String VIEW_MAP_ID = "com.sun.faces.application.view.viewMapId";
    public static final String VIEW_SCOPE_MANAGER = "com.sun.faces.application.view.viewScopeManager";
    private ViewScopeContextManager contextManager;
    private boolean distributable;

    public ViewScopeManager() {
        FacesContext context;
        block3: {
            context = FacesContext.getCurrentInstance();
            try {
                this.contextManager = new ViewScopeContextManager();
            }
            catch (Throwable throwable) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "CDI @ViewScoped bean functionality unavailable");
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "CDI @ViewScoped manager unavailable", throwable);
            }
        }
        WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
        this.distributable = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable);
    }

    public void clear(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped beans from current view map");
        }
        if (this.contextManager != null) {
            this.contextManager.clear(facesContext);
        }
        this.destroyBeans(facesContext, facesContext.getViewRoot().getViewMap(false));
    }

    public void clear(FacesContext facesContext, Map<String, Object> viewMap) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped beans from view map: {0}", viewMap);
        }
        if (this.contextManager != null) {
            this.contextManager.clear(facesContext, viewMap);
        }
        this.destroyBeans(facesContext, viewMap);
    }

    private void destroyBeans(ApplicationAssociate applicationAssociate, Map<String, Object> viewMap) {
        for (Map.Entry<String, Object> entry : viewMap.entrySet()) {
            String name = entry.getKey();
            Object bean = entry.getValue();
            try {
                BeanManager beanManager;
                if (applicationAssociate == null || (beanManager = applicationAssociate.getBeanManager()) == null || !beanManager.isManaged(name)) continue;
                beanManager.destroy(name, bean);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Error calling @PreDestroy on bean with name: " + name, exception);
            }
        }
    }

    public void destroyBeans(FacesContext facesContext, Map<String, Object> viewMap) {
        ApplicationAssociate applicationAssociate;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Destroying @ViewScoped beans from view map: {0}", viewMap);
        }
        if ((applicationAssociate = ApplicationAssociate.getInstance(facesContext.getExternalContext())) != null) {
            this.destroyBeans(applicationAssociate, viewMap);
        }
    }

    ViewScopeContextManager getContextManager() {
        return this.contextManager;
    }

    public static ViewScopeManager getInstance(FacesContext facesContext) {
        if (!facesContext.getExternalContext().getApplicationMap().containsKey(VIEW_SCOPE_MANAGER)) {
            facesContext.getExternalContext().getApplicationMap().put(VIEW_SCOPE_MANAGER, new ViewScopeManager());
        }
        return (ViewScopeManager)facesContext.getExternalContext().getApplicationMap().get(VIEW_SCOPE_MANAGER);
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    @Override
    public void processEvent(SystemEvent se) throws AbortProcessingException {
        if (se instanceof PreDestroyViewMapEvent) {
            this.processPreDestroyViewMap(se);
        }
        if (se instanceof PostConstructViewMapEvent) {
            this.processPostConstructViewMap(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPostConstructViewMap(SystemEvent se) {
        UIViewRoot viewRoot;
        Map<String, Object> viewMap;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Handling PostConstructViewMapEvent");
        }
        if ((viewMap = (viewRoot = (UIViewRoot)se.getSource()).getViewMap(false)) != null) {
            Object session;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (viewRoot.isTransient() && facesContext.isProjectStage(ProjectStage.Development)) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "@ViewScoped beans are not supported on stateless views", "@ViewScoped beans are not supported on stateless views");
                facesContext.addMessage(viewRoot.getClientId(facesContext), message);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "@ViewScoped beans are not supported on stateless views");
                }
            }
            if ((session = facesContext.getExternalContext().getSession(true)) != null) {
                Map viewMaps;
                Map<String, Object> sessionMap = facesContext.getExternalContext().getSessionMap();
                Integer size = (Integer)sessionMap.get(ACTIVE_VIEW_MAPS_SIZE);
                if (size == null) {
                    size = 25;
                }
                if (sessionMap.get(ACTIVE_VIEW_MAPS) == null) {
                    sessionMap.put(ACTIVE_VIEW_MAPS, Collections.synchronizedMap(new LRUMap(size)));
                }
                Map map = viewMaps = (Map)sessionMap.get(ACTIVE_VIEW_MAPS);
                synchronized (map) {
                    String viewMapId = UUID.randomUUID().toString();
                    while (viewMaps.containsKey(viewMapId)) {
                        viewMapId = UUID.randomUUID().toString();
                    }
                    if (viewMaps.size() == size.intValue()) {
                        String eldestViewMapId = (String)viewMaps.keySet().iterator().next();
                        Map eldestViewMap = (Map)viewMaps.remove(eldestViewMapId);
                        this.removeEldestViewMap(facesContext, eldestViewMap);
                    }
                    viewMaps.put(viewMapId, viewMap);
                    viewRoot.getTransientStateHelper().putTransient(VIEW_MAP_ID, viewMapId);
                    viewRoot.getTransientStateHelper().putTransient(VIEW_MAP, viewMap);
                    if (this.distributable) {
                        sessionMap.put(ACTIVE_VIEW_MAPS, viewMaps);
                    }
                }
                if (null != this.contextManager) {
                    this.contextManager.fireInitializedEvent(facesContext, viewRoot);
                }
            }
        }
    }

    private void processPreDestroyViewMap(SystemEvent se) {
        UIViewRoot viewRoot;
        Map<String, Object> viewMap;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Handling PreDestroyViewMapEvent");
        }
        if ((viewMap = (viewRoot = (UIViewRoot)se.getSource()).getViewMap(false)) != null && !viewMap.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (this.contextManager != null) {
                this.contextManager.clear(facesContext, viewMap);
                this.contextManager.fireDestroyedEvent(facesContext, viewRoot);
            }
            this.destroyBeans(facesContext, viewMap);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating session for @ViewScoped beans");
        }
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session;
        Map activeViewMaps;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cleaning up session for @ViewScoped beans");
        }
        if (this.contextManager != null) {
            this.contextManager.sessionDestroyed(hse);
        }
        if ((activeViewMaps = (Map)(session = hse.getSession()).getAttribute(ACTIVE_VIEW_MAPS)) != null) {
            Iterator activeViewMapsIterator = activeViewMaps.values().iterator();
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(hse.getSession().getServletContext());
            while (activeViewMapsIterator.hasNext()) {
                Map viewMap = (Map)activeViewMapsIterator.next();
                this.destroyBeans(applicationAssociate, (Map<String, Object>)viewMap);
            }
            activeViewMaps.clear();
            session.removeAttribute(ACTIVE_VIEW_MAPS);
            session.removeAttribute(ACTIVE_VIEW_MAPS_SIZE);
        }
    }

    private void removeEldestViewMap(FacesContext facesContext, Map<String, Object> eldestViewMap) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Removing eldest view map: {0}", eldestViewMap);
        }
        if (this.contextManager != null) {
            this.contextManager.clear(facesContext, eldestViewMap);
        }
        this.destroyBeans(facesContext, eldestViewMap);
    }
}

