/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.css.visual.actions.Bundle;
import org.netbeans.modules.css.visual.spi.Location;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.actions.NodeAction;

public class OpenLocationAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            final Location location = (Location)activatedNodes[i].getLookup().lookup(Location.class);
            FileObject fob = location.getFile();
            if (fob == null) continue;
            try {
                DataObject dob = DataObject.find((FileObject)fob);
                if (location.getOffset() == -1) {
                    Openable openable = (Openable)dob.getLookup().lookup(Openable.class);
                    if (openable == null) continue;
                    openable.open();
                    continue;
                }
                final EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                if (ec == null) continue;
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] openedPanes = ec.getOpenedPanes();
                        if (openedPanes != null && openedPanes.length > 0) {
                            ec.open();
                            JEditorPane pane = openedPanes[0];
                            pane.setCaretPosition(location.getOffset());
                        } else {
                            try {
                                ec.openDocument();
                                ec.open();
                                openedPanes = ec.getOpenedPanes();
                                if (openedPanes != null && openedPanes.length > 0) {
                                    JEditorPane pane = openedPanes[0];
                                    pane.setCaretPosition(location.getOffset());
                                }
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(OpenLocationAction.class.getName()).log(Level.INFO, null, ex);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return Bundle.OpenLocationAction_displayName();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

