/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.css.visual.api.EditCSSRulesAction;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EditCSSRulesEditorAction
implements ActionListener {
    private final EditorCookie context;

    public EditCSSRulesEditorAction(EditorCookie context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            StyledDocument doc = this.context.openDocument();
            final FileObject file = DataLoadersBridge.getDefault().getFileObject((Document)doc);
            if (file == null) {
                return;
            }
            JEditorPane[] panes = this.context.getOpenedPanes();
            if (panes == null || panes.length == 0) {
                return;
            }
            JEditorPane pane = panes[0];
            final int caret = pane.getCaretPosition();
            Source source = Source.create((FileObject)file);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    if (ri == null) {
                        return;
                    }
                    HtmlParserResult result = (HtmlParserResult)ri.getParserResult();
                    Node element = result.findBySemanticRange(caret, true);
                    if (element instanceof OpenTag) {
                        OpenTag tag = (OpenTag)element;
                        EditCSSRulesAction action = new EditCSSRulesAction();
                        action.setContext(file);
                        action.setHtmlSourceElementHandle(tag, result.getSnapshot(), file);
                        action.actionPerformed(null);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

