/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.DerbyRegistration;
import org.netbeans.modules.derby.Util;
import org.openide.util.Utilities;

public class JDKDerbyHelper {
    private static final Logger LOGGER = Logger.getLogger(JDKDerbyHelper.class.getName());
    private static final JDKDerbyHelper INSTANCE = new JDKDerbyHelper();
    private final String javaHome = System.getProperty("java.home");
    private final String javaVersion = System.getProperty("java.version");

    public static JDKDerbyHelper forDefault() {
        return INSTANCE;
    }

    private JDKDerbyHelper() {
    }

    public boolean canBundleDerby() {
        return true;
    }

    public String findDerbyLocation() {
        File locInJDK;
        String result;
        if (!this.canBundleDerby()) {
            return null;
        }
        String derbyHome = DerbyRegistration.getRegisteredDerbyHome();
        if (derbyHome != null) {
            LOGGER.log(Level.FINE, "Registered JavaDB:  " + derbyHome);
            File derbyHomeFile = new File(derbyHome);
            result = JDKDerbyHelper.testDerbyInstallLocation(derbyHomeFile);
            if (result != null) {
                return result;
            }
        }
        if ((locInJDK = JDKDerbyHelper.getLocationInJDK(this.javaHome)) != null) {
            LOGGER.log(Level.FINE, "JavaDB in JDK(" + this.javaVersion + "):  " + locInJDK);
            result = JDKDerbyHelper.testDerbyInstallLocation(locInJDK);
            if (result != null) {
                return result;
            }
        }
        if (Utilities.isWindows()) {
            File derbyDirFile;
            String result2;
            LOGGER.log(Level.FINE, "Operating system: Windows");
            String programFilesPath = System.getenv("ProgramFiles");
            LOGGER.log(Level.FINE, "Program Files path: {0}", programFilesPath);
            if (programFilesPath != null && (result2 = JDKDerbyHelper.testDerbyInstallLocation(derbyDirFile = new File(programFilesPath, "Sun/JavaDB"))) != null) {
                return result2;
            }
        }
        if (Utilities.isUnix()) {
            LOGGER.log(Level.FINE, "Operating system: Unix");
            result = JDKDerbyHelper.testDerbyInstallLocation(new File("/opt/SUNWjavadb"));
            if (result != null) {
                return result;
            }
            result = JDKDerbyHelper.testDerbyInstallLocation(new File("/opt/sun/javadb"));
            if (result != null) {
                return result;
            }
            result = JDKDerbyHelper.testDerbyInstallLocation(new File("/usr/share/javadb"));
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private static File getLocationInJDK(String javaHome) {
        File dir = new File(javaHome);
        assert (dir != null && dir.exists() && dir.isDirectory()) : "java.home is directory";
        File loc = new File(dir.getParentFile(), "db");
        return loc != null && loc.exists() && loc.isDirectory() ? loc : null;
    }

    private static String testDerbyInstallLocation(File directory) {
        LOGGER.log(Level.FINE, "Testing directory: {0}", directory);
        if (Util.isDerbyInstallLocation(directory)) {
            return directory.getAbsolutePath();
        }
        return null;
    }
}

