/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class CompletionUtils {
    private static String cachedPrefix = null;
    private static Pattern cachedPattern = null;

    public static boolean startsWith(CharSequence theString, String prefix) {
        if (CompletionUtils.isCamelCasePrefix(prefix)) {
            return CompletionUtils.startsWithCamelCase(theString, prefix);
        }
        return theString.toString().toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean isCamelCasePrefix(String prefix) {
        if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!Character.isUpperCase(prefix.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithCamelCase(CharSequence theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix) || cachedPattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = CompletionUtils.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(Pattern.quote(token));
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedPattern = Pattern.compile(sb.toString());
        }
        return cachedPattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String getSimpleName(String fqn) {
        if (fqn == null) {
            return null;
        }
        int lastDot = fqn.lastIndexOf(46);
        return lastDot == -1 ? fqn : fqn.substring(lastDot + 1);
    }

    public static Callable<String> makeFxNamespaceCreator(CompletionContext ctx) {
        Position pos;
        final String existingPrefix = ctx.findFxmlNsPrefix();
        if (existingPrefix != null) {
            return new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return existingPrefix;
                }
            };
        }
        final String prefix = ctx.findPrefixString("http://javafx.com/fxml/1", "fx");
        final Document doc = ctx.getDoc();
        try {
            pos = NbDocument.createPosition((Document)doc, (int)ctx.getRootAttrInsertOffset(), (Position.Bias)Position.Bias.Forward);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            pos = null;
        }
        final Position finalPos = pos;
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (finalPos == null) {
                    return prefix;
                }
                doc.insertString(finalPos.getOffset(), "xmlns:" + prefix + "=\"" + "http://javafx.com/fxml/1" + "\" ", null);
                return prefix;
            }
        };
    }
}

