/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.GoToSourceAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MethodsNode
extends AbstractNode
implements OpenCookie {
    private final String ejbClass;
    private final MetadataModel<EjbJarMetadata> model;
    private final EjbViewController controller;
    private DataObject dataObject;
    private ViewType viewType;

    public MethodsNode(String ejbClass, EjbJar ejbModule, Children children, ViewType viewType) {
        this(new InstanceContent(), ejbClass, ejbModule, children, viewType);
    }

    private MethodsNode(InstanceContent content, final String ejbClass, EjbJar ejbModule, Children children, final ViewType viewType) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.ejbClass = ejbClass;
        this.model = ejbModule.getMetadataModel();
        this.controller = new EjbViewController(ejbClass, ejbModule);
        this.viewType = viewType;
        String iClassName = null;
        try {
            iClassName = (String)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws Exception {
                    EntityAndSession entityAndSession = (EntityAndSession)metadata.findByEjbClass(ejbClass);
                    if (entityAndSession != null) {
                        switch (viewType) {
                            case NO_INTERFACE: {
                                return entityAndSession.getEjbClass();
                            }
                            case LOCAL: {
                                return entityAndSession.getLocal();
                            }
                            case REMOTE: {
                                return entityAndSession.getRemote();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.dataObject = this.controller.getDataObject(iClassName);
        content.add((Object)this);
        if (this.dataObject != null) {
            content.add((Object)this.dataObject);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new GoToSourceAction(this.dataObject, NbBundle.getMessage(MethodsNode.class, (String)"LBL_GoToSourceGroup")), SystemAction.get(AddActionGroup.class)};
    }

    public Action getPreferredAction() {
        return new GoToSourceAction(this.dataObject, NbBundle.getMessage(MethodsNode.class, (String)"LBL_GoToSourceGroup"));
    }

    public void open() {
        OpenCookie cookie;
        DataObject dataObject = this.controller.getBeanDo();
        if (dataObject != null && (cookie = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
            cookie.open();
        }
    }

    public boolean isLocal() {
        return this.viewType == ViewType.LOCAL;
    }

    public boolean isRemote() {
        return this.viewType == ViewType.REMOTE;
    }

    public static enum ViewType {
        NO_INTERFACE,
        LOCAL,
        REMOTE;

    }
}

