/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateManyToManyRelationshipHint;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateOneToManyRelationshipHint;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateUnidirOneToManyRelationshipHint;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class MVRelationshipForEntityTypeAttrDefined
extends JPAEntityAttributeCheck {
    @Override
    public Collection<ErrorDescription> check(final JPAProblemContext ctx, final HintContext hc, final AttributeWrapper attrib) {
        Element typeElement;
        List<? extends TypeMirror> typeArgs;
        if (ctx.isEmbeddable()) {
            return null;
        }
        TypeMirror type = attrib.getType();
        final ArrayList<ErrorDescription> ret = new ArrayList<ErrorDescription>();
        if (type.getKind() == TypeKind.DECLARED && (typeArgs = ((DeclaredType)type).getTypeArguments()).size() == 1 && (typeElement = ctx.getCompilationInfo().getTypes().asElement(typeArgs.get(0))) != null && typeElement.getKind() == ElementKind.CLASS) {
            try {
                MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
                model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                    public Void run(EntityMappingsMetadata metadata) {
                        Entity entity = ModelUtils.getEntity(ctx.getMetaData(), (TypeElement)typeElement);
                        String remoteClassName = ((TypeElement)typeElement).getQualifiedName().toString();
                        if (entity != null) {
                            ElementHandle classHandle = ElementHandle.create((Element)ctx.getJavaClass());
                            ElementHandle elemHandle = ElementHandle.create((Element)attrib.getJavaElement());
                            CreateUnidirOneToManyRelationshipHint fix1 = new CreateUnidirOneToManyRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, (ElementHandle<Element>)elemHandle);
                            CreateOneToManyRelationshipHint fix2 = new CreateOneToManyRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, ctx.getAccessType(), attrib.getName(), remoteClassName);
                            CreateManyToManyRelationshipHint fix3 = new CreateManyToManyRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, ctx.getAccessType(), attrib.getName(), remoteClassName);
                            Tree elementTree = ctx.getCompilationInfo().getTrees().getTree(attrib.getJavaElement());
                            Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
                            ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(MVRelationshipForEntityTypeAttrDefined.class, (String)"MSG_MVEntityRelationNotDefined"), (Fix[])new Fix[]{fix1, fix2, fix3});
                            ret.add(error);
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }
}

