/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.spi.SeleniumTestingProviderImplementation;
import org.netbeans.modules.selenium2.webclient.ui.customizer.CompositeCategoryProviderImpl;
import org.netbeans.modules.selenium2.webclient.ui.customizer.SelectProviderPanel;
import org.netbeans.modules.selenium2.webclient.ui.customizer.SeleniumTestingProviderAccessor;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public final class SeleniumTestingProviders {
    public static final String SELENIUM_TESTING_PATH = "Selenium/Testing";
    public static final String CUSTOMIZER_SELENIUM_TESTING_IDENT = "SELENIUM_TESTING";
    private static final Lookup.Result<SeleniumTestingProviderImplementation> SELENIUM_TESTING_PROVIDERS = Lookups.forPath((String)"Selenium/Testing").lookupResult(SeleniumTestingProviderImplementation.class);
    private static final SeleniumTestingProviders INSTANCE = new SeleniumTestingProviders();
    private final List<SeleniumTestingProvider> seleniumTestingProviders = new CopyOnWriteArrayList<SeleniumTestingProvider>();

    private SeleniumTestingProviders() {
        this.initProviders();
    }

    public static SeleniumTestingProviders getDefault() {
        return INSTANCE;
    }

    public List<SeleniumTestingProvider> getSeleniumTestingProviders() {
        return new ArrayList<SeleniumTestingProvider>(this.seleniumTestingProviders);
    }

    @CheckForNull
    public SeleniumTestingProvider findSeleniumTestingProvider(@NonNull String identifier) {
        Parameters.notNull((CharSequence)"identifier", (Object)identifier);
        for (SeleniumTestingProvider seleniumTestingProvider : this.seleniumTestingProviders) {
            if (!seleniumTestingProvider.getIdentifier().equals(identifier)) continue;
            return seleniumTestingProvider;
        }
        return null;
    }

    @CheckForNull
    public SeleniumTestingProvider getSeleniumTestingProvider(@NonNull Project project, boolean showSelectionPanel) {
        SeleniumTestingProvider seleniumTestingProvider;
        Parameters.notNull((CharSequence)"project", (Object)project);
        for (SeleniumTestingProvider seleniumTestingProvider2 : this.seleniumTestingProviders) {
            if (!seleniumTestingProvider2.isEnabled(project)) continue;
            return seleniumTestingProvider2;
        }
        if (showSelectionPanel && (seleniumTestingProvider = SelectProviderPanel.open()) != null) {
            seleniumTestingProvider.notifyEnabled(project, true);
            return seleniumTestingProvider;
        }
        return null;
    }

    public void setSeleniumTestingProvider(@NonNull Project project, @NonNull SeleniumTestingProvider seleniumTestingProvider) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"seleniumTestingProvider", (Object)seleniumTestingProvider);
        SeleniumTestingProvider currentTestingProvider = this.getSeleniumTestingProvider(project, false);
        if (currentTestingProvider != null) {
            if (currentTestingProvider.getIdentifier().equals(seleniumTestingProvider.getIdentifier())) {
                return;
            }
            currentTestingProvider.notifyEnabled(project, false);
        }
        seleniumTestingProvider.notifyEnabled(project, true);
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer() {
        return new CompositeCategoryProviderImpl();
    }

    private void initProviders() {
        assert (this.seleniumTestingProviders.isEmpty()) : "Empty providers expected but: " + this.seleniumTestingProviders;
        this.seleniumTestingProviders.addAll(this.map(SELENIUM_TESTING_PROVIDERS.allInstances()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitProviders() {
        List<SeleniumTestingProvider> list = this.seleniumTestingProviders;
        synchronized (list) {
            this.clearProviders();
            this.initProviders();
        }
    }

    private void clearProviders() {
        this.seleniumTestingProviders.clear();
    }

    private Collection<SeleniumTestingProvider> map(Collection<? extends SeleniumTestingProviderImplementation> providers) {
        ArrayList<SeleniumTestingProvider> result = new ArrayList<SeleniumTestingProvider>();
        for (SeleniumTestingProviderImplementation seleniumTestingProviderImplementation : providers) {
            result.add(SeleniumTestingProviderAccessor.getDefault().create(seleniumTestingProviderImplementation));
        }
        return result;
    }

    static {
        SELENIUM_TESTING_PROVIDERS.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                INSTANCE.reinitProviders();
            }
        });
    }
}

