/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

public class ReflectionDetailsProvider
extends DetailsProvider.Basic {
    private static final String CLASS_MASK = "java.lang.Class";
    private static final String CONSTRUCTOR_MASK = "java.lang.reflect.Constructor";
    private static final String METHOD_MASK = "java.lang.reflect.Method";
    private static final String FIELD_MASK = "java.lang.reflect.Field";
    private static final String PARAMETER_MASK = "java.lang.reflect.Parameter";

    public ReflectionDetailsProvider() {
        super(CLASS_MASK, CONSTRUCTOR_MASK, METHOD_MASK, FIELD_MASK, PARAMETER_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (CLASS_MASK.equals(className)) {
            JavaClass jclass;
            String name = DetailsUtils.getInstanceFieldString(instance, "name", heap);
            if (name == null && CLASS_MASK.equals(instance.getJavaClass().getName()) && (jclass = heap.getJavaClassByID(instance.getInstanceId())) != null) {
                name = BrowserUtils.getSimpleType(jclass.getName());
            }
            return name;
        }
        if (CONSTRUCTOR_MASK.equals(className)) {
            Object value = instance.getValueOfField("clazz");
            if (value instanceof Instance) {
                return this.getDetailsString(CLASS_MASK, (Instance)value, heap);
            }
        } else {
            if (METHOD_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "name", heap);
            }
            if (FIELD_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "name", heap);
            }
            if (PARAMETER_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "name", heap);
            }
        }
        return null;
    }
}

