/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class MathDetailsProvider
extends DetailsProvider.Basic {
    private static final String BIG_INTEGRER_MASK = "java.math.BigInteger";
    private static final String BIG_DECIMAL_MASK = "java.math.BigDecimal";

    public MathDetailsProvider() {
        super(BIG_INTEGRER_MASK, BIG_DECIMAL_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        String val;
        if (BIG_INTEGRER_MASK.equals(className)) {
            BigInteger bint = this.getBigInteger(instance);
            if (bint != null) {
                return bint.toString();
            }
        } else if (BIG_DECIMAL_MASK.equals(className) && (val = DetailsUtils.getInstanceFieldString(instance, "stringCache", heap)) == null) {
            BigInteger bint;
            int scale = DetailsUtils.getIntFieldValue(instance, "scale", 0);
            long intCompact = DetailsUtils.getLongFieldValue(instance, "intCompact", Long.MIN_VALUE);
            if (intCompact != Long.MIN_VALUE) {
                return BigDecimal.valueOf(intCompact, scale).toString();
            }
            Object bintInstace = instance.getValueOfField("intVal");
            if (bintInstace instanceof Instance && (bint = this.getBigInteger((Instance)bintInstace)) != null) {
                return new BigDecimal(bint, scale).toString();
            }
        }
        return null;
    }

    private BigInteger getBigInteger(Instance instance) {
        int sig = DetailsUtils.getIntFieldValue(instance, "signum", Integer.MAX_VALUE);
        int[] mag = DetailsUtils.getIntArray(DetailsUtils.getPrimitiveArrayFieldValues(instance, "mag"));
        if (mag != null && sig != Integer.MAX_VALUE) {
            ByteBuffer buffer = ByteBuffer.allocate(mag.length * 4);
            IntBuffer intBuffer = buffer.asIntBuffer();
            intBuffer.put(mag);
            return new BigInteger(sig, buffer.array());
        }
        return null;
    }
}

