/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.json;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.json.simple.JSONValue;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.web.clientproject.api.util.WatchedFile;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class JsonFile {
    private static final Logger LOGGER = Logger.getLogger(JsonFile.class.getName());
    private static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }

        public List creatArrayContainer() {
            return new ArrayList();
        }
    };
    private final WatchedFile watchedFile;
    private final WatchedFields watchedFields;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final ChangeListener watchedFileChangeListener = new WatchedFileChangeListener();
    private Map<String, Object> content;
    private volatile boolean contentInited = false;

    public JsonFile(String fileName, FileObject directory, WatchedFields watchedFields) {
        Parameters.notNull((CharSequence)"watchedFields", (Object)watchedFields);
        this.watchedFile = WatchedFile.create(fileName, directory);
        this.watchedFields = watchedFields.freeze();
        this.watchedFile.addChangeListener(WeakListeners.change((ChangeListener)this.watchedFileChangeListener, (Object)this.watchedFile));
    }

    public void cleanup() {
        this.contentInited = false;
        this.clear(false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.initContent();
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public boolean exists() {
        return this.watchedFile.exists();
    }

    public File getFile() {
        return this.watchedFile.getFile();
    }

    public String getPath() {
        return this.getFile().getAbsolutePath();
    }

    public void refresh() {
        this.clear(false);
        FileUtil.toFileObject((File)this.getFile()).refresh();
    }

    @CheckForNull
    public synchronized Map<String, Object> getContent() {
        this.initContent();
        if (this.content != null) {
            return new LinkedHashMap<String, Object>(this.content);
        }
        File file = this.getFile();
        if (!file.isFile()) {
            return null;
        }
        JSONParser parser = new JSONParser();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            this.content = (Map)parser.parse((Reader)reader, CONTAINER_FACTORY);
        }
        catch (ParseException ex) {
            LOGGER.log(Level.INFO, file.getAbsolutePath(), ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, file.getAbsolutePath(), ex);
        }
        if (this.content == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(this.content);
    }

    @CheckForNull
    public <T> T getContentValue(Class<T> valueType, String ... fieldHierarchy) {
        return this.getContentValue(this.getContent(), valueType, fieldHierarchy);
    }

    protected <T> T getContentValue(Map<String, Object> content, Class<T> valueType, String ... fieldHierarchy) {
        Map subdata = content;
        if (subdata == null) {
            return null;
        }
        for (int i = 0; i < fieldHierarchy.length; ++i) {
            String field = fieldHierarchy[i];
            if (i == fieldHierarchy.length - 1) {
                Object value = subdata.get(field);
                if (value == null) {
                    return null;
                }
                if (valueType.isAssignableFrom(value.getClass())) {
                    return valueType.cast(value);
                }
                return null;
            }
            if ((subdata = (Map)subdata.get(field)) != null) continue;
            return null;
        }
        return null;
    }

    public void setContent(List<String> fieldHierarchy, Object value) throws IOException {
        assert (fieldHierarchy != null);
        assert (!fieldHierarchy.isEmpty());
        assert (value != null);
        assert (!EventQueue.isDispatchThread());
        assert (this.exists());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setContentInternal(fieldHierarchy, value);
    }

    private synchronized void setContentInternal(final List<String> fieldHierarchy, final Object value) throws IOException {
        this.initContent();
        DataObject dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.getFile()));
        EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        assert (editorCookie != null) : "No EditorCookie for " + dataObject;
        boolean modified = editorCookie.isModified();
        StyledDocument document = editorCookie.getDocument();
        if (document == null) {
            document = editorCookie.openDocument();
        }
        assert (document != null);
        final StyledDocument documentRef = document;
        NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){

            @Override
            public void run() {
                JsonFile.this.setContent(documentRef, fieldHierarchy, value);
            }
        });
        if (!modified) {
            editorCookie.saveDocument();
        }
        this.clear(true);
    }

    void setContent(Document document, List<String> fieldHierarchy, Object value) {
        String text;
        try {
            text = document.getText(0, document.getLength());
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            assert (false);
            return;
        }
        ArrayList<String> fields = new ArrayList<String>(fieldHierarchy);
        int fieldIndex = -1;
        int closestFieldIndex = -1;
        int level = -1;
        int searchInLevel = 0;
        String field = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch;
            if (field == null) {
                field = "\"" + JSONValue.escape((String)((String)fields.get(searchInLevel))) + "\"";
            }
            if ((ch = text.charAt(i)) == '{') {
                ++level;
                continue;
            }
            if (ch == '}') {
                --level;
                continue;
            }
            if (Character.isWhitespace(ch) || level != searchInLevel || ch != '\"' || !text.substring(i).startsWith(field)) continue;
            closestFieldIndex = i;
            if (++searchInLevel >= fields.size()) {
                fieldIndex = i;
                break;
            }
            i += field.length();
            field = null;
        }
        assert (field != null);
        if (fieldIndex == -1) {
            while (searchInLevel > 0) {
                fields.remove(0);
                --searchInLevel;
            }
            this.insertNewField(document, fields, value, text, closestFieldIndex);
            return;
        }
        int colonIndex = -1;
        for (int i = fieldIndex + field.length(); i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case ' ': {
                    break;
                }
                case ':': {
                    colonIndex = i;
                    break;
                }
                default: {
                    return;
                }
            }
            if (colonIndex != -1) break;
        }
        if (colonIndex == -1) {
            return;
        }
        int valueStartIndex = -1;
        for (int i = colonIndex + 1; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            valueStartIndex = i;
            break;
        }
        if (valueStartIndex == -1) {
            return;
        }
        char valueFirstChar = text.charAt(valueStartIndex);
        int valueEndIndex = -1;
        for (int i = valueStartIndex + 1; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (valueFirstChar == '\"') {
                if (ch == '\"') {
                    valueEndIndex = i + 1;
                }
            } else {
                if (Character.isDigit(ch) || ch == '.') continue;
                valueEndIndex = i;
            }
            if (valueEndIndex != -1) break;
        }
        if (valueEndIndex == -1) {
            return;
        }
        this.insertValue(document, valueStartIndex, valueEndIndex, JSONValue.toJSONString((Object)value), !(value instanceof String) && !(value instanceof Number));
    }

    private void insertNewField(Document document, List<String> fieldHierarchy, Object value, String text, int index) {
        boolean commaBefore;
        int startIndex = index;
        if (startIndex == -1) {
            startIndex = text.lastIndexOf(125);
            if (startIndex != -1) {
                char ch;
                while (Character.isWhitespace(ch = text.charAt(--startIndex))) {
                }
                ++startIndex;
            }
            commaBefore = true;
        } else {
            if ((startIndex = text.indexOf(123, startIndex)) != -1) {
                ++startIndex;
            }
            commaBefore = false;
        }
        if (startIndex == -1) {
            startIndex = text.length();
        }
        StringBuilder sb = new StringBuilder();
        if (commaBefore) {
            sb.append(',');
            sb.append('\n');
        }
        int braces = -1;
        for (String field : fieldHierarchy) {
            if (braces > -1) {
                sb.append('{');
                sb.append('\n');
            }
            sb.append('\"');
            sb.append(JSONValue.escape((String)field));
            sb.append('\"');
            sb.append(':');
            ++braces;
        }
        sb.append(JSONValue.toJSONString((Object)value));
        for (int i = 0; i < braces; ++i) {
            sb.append('}');
            sb.append('\n');
        }
        if (!commaBefore) {
            sb.append(',');
        }
        this.insertValue(document, startIndex, -1, sb.toString(), true);
    }

    private void insertValue(Document document, int valueStartIndex, int valueEndIndex, String value, boolean format) {
        block7: {
            try {
                if (valueEndIndex != -1) {
                    document.remove(valueStartIndex, valueEndIndex - valueStartIndex);
                }
                document.insertString(valueStartIndex, value, null);
                if (format) {
                    this.reformat(document, valueStartIndex, valueStartIndex + value.length());
                }
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                if (LOGGER.isLoggable(Level.FINE)) {
                    try {
                        LOGGER.log(Level.FINE, "[JSON]: [{0}]", document.getText(0, document.getLength()));
                    }
                    catch (BadLocationException ex1) {
                        LOGGER.log(Level.FINE, "Cannot get document text", ex1);
                    }
                    LOGGER.log(Level.FINE, "start, end: {0}, {1}", new Object[]{valueStartIndex, valueEndIndex});
                    LOGGER.log(Level.FINE, "[new text]: [{0}]", value);
                }
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(Document document, int startOffset, int endOffset) throws BadLocationException {
        Reformat reformat = Reformat.get((Document)document);
        reformat.lock();
        try {
            reformat.reformat(startOffset, endOffset);
        }
        finally {
            reformat.unlock();
        }
    }

    private void initContent() {
        if (this.contentInited) {
            return;
        }
        this.contentInited = true;
        this.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(boolean fireChanges) {
        Map<String, Object> oldContent;
        Map<String, Object> newContent = null;
        JsonFile jsonFile = this;
        synchronized (jsonFile) {
            oldContent = this.content;
            if (this.content != null) {
                LOGGER.log(Level.FINE, "Clearing cached content of {0}", this.watchedFile);
                this.content = null;
            }
            if (fireChanges) {
                newContent = this.getContent();
            }
        }
        if (fireChanges) {
            this.fireChanges(oldContent, newContent);
        }
    }

    private void fireChanges(@NullAllowed Map<String, Object> oldContent, @NullAllowed Map<String, Object> newContent) {
        if (this.watchedFields == WatchedFields.ALL) {
            if (!Objects.equals(oldContent, newContent)) {
                this.propertyChangeSupport.firePropertyChange(null, null, null);
            }
            return;
        }
        List<Pair<String, String[]>> data = this.watchedFields.getData();
        assert (data != null);
        for (Pair<String, String[]> watchedField : data) {
            Object newValue;
            String propertyName = (String)watchedField.first();
            String[] field = (String[])watchedField.second();
            Object oldValue = this.getContentValue(oldContent, Object.class, field);
            if (Objects.equals(oldValue, newValue = this.getContentValue(newContent, Object.class, field))) continue;
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private final class WatchedFileChangeListener
    implements ChangeListener {
        private WatchedFileChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JsonFile.this.clear(true);
        }
    }

    public static final class WatchedFields {
        private static final WatchedFields ALL = new WatchedFields(null);
        private final List<Pair<String, String[]>> data;
        private volatile boolean frozen = false;

        private WatchedFields(List<Pair<String, String[]>> data) {
            this.data = data;
        }

        public static WatchedFields create() {
            return new WatchedFields(new ArrayList<Pair<String, String[]>>());
        }

        public static WatchedFields all() {
            return ALL;
        }

        public WatchedFields add(@NonNull String propertyName, String ... fieldHierarchy) {
            if (this.data == null) {
                throw new IllegalStateException("Listening to all changes already");
            }
            if (this.frozen) {
                throw new IllegalStateException("Cannot add no more fields");
            }
            Parameters.notWhitespace((CharSequence)"propertyName", (CharSequence)propertyName);
            Parameters.notNull((CharSequence)"fieldHierarchy", (Object)fieldHierarchy);
            int length = fieldHierarchy.length;
            if (length == 0) {
                throw new IllegalArgumentException("No field given");
            }
            String[] field = new String[length];
            System.arraycopy(fieldHierarchy, 0, field, 0, length);
            this.data.add((Pair<String, String[]>)Pair.of((Object)propertyName, (Object)field));
            return this;
        }

        @CheckForNull
        List<Pair<String, String[]>> getData() {
            if (this.data == null) {
                return null;
            }
            return new CopyOnWriteArrayList<Pair<String, String[]>>(this.data);
        }

        WatchedFields freeze() {
            this.frozen = true;
            return this;
        }
    }
}

