/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.Bundle;
import org.netbeans.modules.mercurial.ui.diff.DiffTopComponent;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DiffAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/resources/icons/diff.png";

    public DiffAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && !ctxFiles.isEmpty();
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Diff";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        boolean bNotManaged;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        String contextName = Utils.getContextDisplayName((VCSContext)context);
        File[] files = context.getRootFiles().toArray(new File[context.getRootFiles().size()]);
        boolean bl = bNotManaged = !HgUtils.isFromHgRepository(context) || files == null || files.length == 0;
        if (bNotManaged) {
            OutputLogger logger = Mercurial.getInstance().getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_TITLE"));
            logger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW_INFO"));
            logger.output("");
            logger.closeLog();
            JOptionPane.showMessageDialog(Utilities.findDialogParent(), NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        DiffAction.diff(context, 0, contextName);
    }

    public static void diff(VCSContext ctx, int type, String contextName) {
        MultiDiffPanel panel = new MultiDiffPanel(ctx, type, contextName);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(Bundle.CTL_DiffPanel_Title(contextName));
        tc.open();
        tc.requestActive();
    }

    public static void diff(File file1, HgLogMessage.HgRevision rev1, File file2, HgLogMessage.HgRevision rev2) {
        DiffAction.diff(file1, rev1, file2, rev2, -1);
    }

    public static void diff(File file1, HgLogMessage.HgRevision rev1, File file2, HgLogMessage.HgRevision rev2, int lineNumber) {
        MultiDiffPanel panel = new MultiDiffPanel(file2, rev1, rev2, new FileInformation(8, new FileStatus(file2, file1), false), false, lineNumber);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(Bundle.CTL_DiffPanel_Title(file2.getName()));
        tc.open();
        tc.requestActive();
    }

    public void diff(File[] roots, HgLogMessage.HgRevision rev1, HgLogMessage.HgRevision rev2, String contextName, boolean fixedRevisions, boolean displayUnversionedFiles) {
        MultiDiffPanel panel = new MultiDiffPanel(roots, rev1, rev2, fixedRevisions, displayUnversionedFiles);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(Bundle.CTL_DiffPanel_Title(contextName));
        tc.open();
        tc.requestActive();
    }
}

